#include <windows.h>


#include "CConfig.h"

CConfig::CConfig(char* name, char* file){
	this->appName = strdup(name);
	this->appFile = strdup(file);
	this->readConfigData();
	return;
}

CConfig::~CConfig(){
	free(this->appName);
	free(this->appFile);
	return;
}

void CConfig::readConfigData(){
	this->xRes = GetPrivateProfileInt(this->appName, "xres", 640, this->appFile);
	this->yRes = GetPrivateProfileInt(this->appName, "yres", 480, this->appFile);
	this->colorDepth = GetPrivateProfileInt(this->appName, "bpp", 32, this->appFile);
	this->zDef = GetPrivateProfileInt(this->appName, "zres", 24, this->appFile);

	this->usePrettyText = (GetPrivateProfileInt(this->appName, "usePrettyText", 1, this->appFile) == 1);
	this->updtBgTexture = (GetPrivateProfileInt(this->appName, "updtBackTexture", 0, this->appFile) == 1);

	this->aaQuality = (AA_QUALITY)(GetPrivateProfileInt(this->appName, "nxfsaa", 0, this->appFile));

	return;
}

