#include <windows.h>
#include <stdio.h>
#include <iostream>

//#include "stdafx.h"

#include <vector>

#include "CTaskList.h"



//-----------------------------------------------------------

#define TS_ALLOCUNIT					64
#define HUNG_TIMEOUT					250

int g_nTs;

HICON GetWindowIcon(HWND hwnd) {

	HICON hIcon = NULL;
	if (!SendMessageTimeout(hwnd, WM_GETICON, ICON_BIG, 0, 
		SMTO_ABORTIFHUNG, HUNG_TIMEOUT, (PDWORD_PTR)&hIcon)) {
		DWORD dwErr = GetLastError();
		if (dwErr == 0 || dwErr == 1460)
			goto _HUNG_ICON;
	}			
	if(!hIcon) hIcon = (HICON)(UINT_PTR)GetClassLongPtr(hwnd, GCLP_HICON);
	if(!hIcon) {
_HUNG_ICON:
		hIcon = LoadIcon(NULL, IDI_APPLICATION);
	}
	return(hIcon);
}

std::vector<CTaskInfo> lst;

BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM /*lParam*/) {

	DWORD dwStyle = GetWindowLongPtr(hwnd, GWL_STYLE);
	if (dwStyle & WS_VISIBLE) {

		DWORD dwStyleEx = GetWindowLongPtr(hwnd, GWL_EXSTYLE);		

		HWND hwndOwner, hwndTmp = hwnd;
		do {
			hwndOwner = hwndTmp;
			hwndTmp = GetWindow(hwndTmp, GW_OWNER);
		} while (hwndTmp);
		
		//if(hwndOwner != hwnd){
		//	return TRUE;
		//}

		std::vector <CTaskInfo>::iterator iter;
		int i = 0;
		iter = lst.begin( );
		int nTs = (int)lst.size();
		while( i < nTs && (iter++)->task != hwndOwner){
			i++;
		}
		if (i < nTs){
			return(TRUE);
		}

		
		if ((!(dwStyleEx & WS_EX_TOOLWINDOW) || (dwStyleEx & WS_EX_APPWINDOW)) || 
			(dwStyleEx & WS_EX_TOOLWINDOW && hwndOwner != hwnd && !(dwStyle & WS_POPUP)))  {

				CTaskInfo cti;
				cti.task = hwndOwner;
				cti.taskPv = hwnd;
				cti.taskIcon = GetWindowIcon(hwndOwner);				
				GetWindowText(cti.task,cti.taskText,MAX_TEXT_LENGHT);
				cti.taskGLTexture = -1; //Create an OpenGL texture from hwnd 
				RECT r;
				GetWindowRect(cti.taskPv, &r);
				cti.taskWidth  = abs(r.right - r.left);
				cti.taskHeight = abs(r.bottom - r.top);
				if(IsIconic(cti.task)){					
					cti.taskIconic = true;					
				} else {					
					cti.taskIconic = false;					
				}
 				
				lst.push_back(cti);				
			}			
	}
	return(TRUE);
}

//-----------------------------------------------------------

int CTaskList::myEnumDesktopWindows() {

	EnumDesktopWindows(NULL, EnumWindowsProc, NULL);

	//lst.unique();

	taskList = std::vector<CTaskInfo>(lst);	
	lst.clear();
	
	return (int)taskList.size();
}

CTaskList::CTaskList(){
	taskList.clear();		
	return;
}

CTaskList::~CTaskList(){
	taskList.clear();		
	return;
}


BOOL CTaskList::addTask(CTaskInfo ti){
	BOOL res = FALSE;
	try {
		taskList.push_back(ti);
		res = TRUE;
	} catch (...) {}
	
	return res;
}

BOOL CTaskList::removeTask(CTaskInfo ti){
	BOOL res = FALSE;
	int idx = 0;
	for(idx=0; idx < this->getNrTasks(); idx++){
		CTaskInfo aux;
		aux.task = (taskList.begin()+idx)->task;
		aux.taskPv = (taskList.begin()+idx)->taskPv;
		if(ti == aux){
			break;
		}
	}
	taskList.erase((taskList.begin()+idx));
	res = TRUE;
	
	return res;
}

BOOL CTaskList::clearTasks(){
	BOOL res = FALSE;
	
	taskList.clear();	
	res = (taskList.empty())?TRUE:FALSE;		
	
	return res;
}

int CTaskList::getNrTasks(){
	return (int)taskList.size();
}

CTaskInfo CTaskList::getTask(int idx){
	std::vector <CTaskInfo>::iterator iter;
	CTaskInfo res;

	if(idx >= 0 && idx < this->getNrTasks()){
	
		res = this->taskList[idx];	
	
	}
	return res;
}

int CTaskList::fillTaskList(){
	int nTsk = myEnumDesktopWindows();
	return nTsk;
}
BOOL CTaskList::printTaskList(std::ostream &out){
	std::vector <CTaskInfo>::iterator iter;

	out << "Star of processes enumeration:" << "\n";
	for ( iter = taskList.begin( ); iter != taskList.end( ); iter++ ){		
		out << " " << iter->task << " " << iter->taskPv << " - " << iter->taskText << "\n";		
	}
	out << "End of processes enumeration.";
	out << std::endl;

	
	return TRUE;
	
}

void CTaskList::showTasks(){
	std::vector <CTaskInfo>::iterator iter;

	for ( iter = taskList.begin( ); iter != taskList.end( ); iter++ ){
		ShowWindow(iter->task, SW_RESTORE);
		SetForegroundWindow(iter->task);
	}

	return;
}

void CTaskList::hideTasks(){
	std::vector <CTaskInfo>::iterator iter;

	for ( iter = taskList.begin( ); iter != taskList.end( ); iter++ ){
		ShowWindow(iter->task, SW_MINIMIZE);
	}

	return;
}