#pragma once
#ifndef _CTASKLIST_
#define _CTASKLIST_

#include <vector>

#define MAX_TEXT_LENGHT	512

class CTaskInfo {
public:
	HWND task;
	HWND taskPv;
	HICON taskIcon;
	char taskText[MAX_TEXT_LENGHT + 2];
	unsigned int taskGLTexture;
	int taskWidth;
	int taskHeight;
	bool taskIconic;

	//bool operator isKin(CTaskInfo cti)
	//{
	//	bool res = false;
	//	// Return the scale vector
	//	if(strncmp(this->taskText, cti.taskText, MAX_TEXT_LENGHT * sizeof(char)) == 0){
	//		res = true;
	//	}
	//	return res;
	//}

	// Here we overload the == operator so we can divide by a scalar
	bool operator==(CTaskInfo cti)
	{
		return (this->task == cti.task && this->taskPv == cti.taskPv);
	}

	bool operator==(CTaskInfo *cti)
	{
		return (this->task == cti->task && this->taskPv == cti->taskPv);
	}

	// Here we overload the > operator so we can divide by a scalar
	bool operator>(CTaskInfo cti)
	{
		return (GetParent(cti.task) == this->task);
	}
};


class CTaskList {
public:
	std::vector<CTaskInfo> taskList;
	BOOL addTask(CTaskInfo);
	BOOL removeTask(CTaskInfo);
	BOOL clearTasks();

	CTaskList();
	~CTaskList();

	//BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM );
	int myEnumDesktopWindows();
	int getNrTasks();
	CTaskInfo getTask(int idx);
	int fillTaskList();
	BOOL printTaskList(std::ostream &out);
	void hideTasks();
	void showTasks();
};


#endif
