#pragma once
#ifndef _CVECTOR3_H
#define _CVECTOR3_H

#include <math.h>
#include <vector>

// This is our basic 3D point/vector class
class CVector3
{
public:
	float x, y, z;	
	
	// A default constructor
	CVector3() {
		x = 0.0; y = 0.0; z = 0.0;
	}

	// This is our constructor that allows us to initialize our data upon creating an instance
	CVector3(float X, float Y, float Z) 
	{ 
		x = X; y = Y; z = Z;
	}

	// Here we overload the + operator so we can add vectors together 
	CVector3 operator+(CVector3 vVector)
	{
		// Return the added vectors result.
		return CVector3(vVector.x + x, vVector.y + y, vVector.z + z);
	}

	// Here we overload the - operator so we can subtract vectors 
	CVector3 operator-(CVector3 vVector)
	{
		// Return the subtracted vectors result
		return CVector3(x - vVector.x, y - vVector.y, z - vVector.z);
	}
	
	// Here we overload the * operator so we can multiply by scalars
	CVector3 operator*(float num)
	{
		// Return the scaled vector
		return CVector3(x * num, y * num, z * num);
	}
	
	// Here we overload the / operator so we can divide by a scalar
	CVector3 operator/(float num)
	{
		// Return the scale vector
		return CVector3(x / num, y / num, z / num);
	}							

	// Here we overload the == operator so we can divide by a scalar
	bool operator==(CVector3 vV)
	{
		// Return the scale vector
		return ((x == vV.x) && (y == vV.y) && (z == vV.z));
	}
	// Here we overload the > operator so we can divide by a scalar
	bool operator>(CVector3 vV)
	{
		// Return the scale vector
		return (x > vV.x) && (y > vV.y) && (z > vV.z);
	}
	// Here we overload the < operator so we can divide by a scalar
	bool operator<(CVector3 vV)
	{
		// Return the scale vector
		return (x < vV.x) && (y < vV.y) && (z < vV.z);
	}
	// Here we overload the >= operator so we can divide by a scalar
	bool operator>=(CVector3 vV)
	{
		// Return the scale vector
		return (x >= vV.x) && (y >= vV.y) && (z >= vV.z);
	}
	// Here we overload the >= operator so we can divide by a scalar
	bool operator<=(CVector3 vV)
	{
		// Return the scale vector
		return (x <= vV.x) && (y <= vV.y) && (z <= vV.z);
	}

	
};

// *Note* The code below was thrown in to calculate the normals of the triangles
// that we are displaying.  Instead of complicating the tutorial with separating
// the normals too, I decided to just calculate face normals on the fly so we can
// the depth of the terrain better when we have lighting turned on. 


CVector3 Normalize(CVector3 vVector);
float Magnitude(CVector3 vNormal);
CVector3 Cross(CVector3 vVector1, CVector3 vVector2);
float Dot(CVector3 vV1, CVector3 vV2);

#endif