/**************************************
*                                     *
*   Jeff Molofee's Basecode Example   *
*          nehe.gamedev.net           *
*                2001                 *
*                                     *
**************************************/

#include <windows.h>											// Header File For Windows
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library
#include "NeHeGL.h"												// Header File For NeHeGL

#include "stdlib.h"
#include "stdio.h"

#include "Utils.h"

#pragma comment( lib, "opengl32.lib" )							// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )								// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )								// Search For GLaux.lib While Linking

#ifndef CDS_FULLSCREEN											// CDS_FULLSCREEN Is Not Defined By Some
#define CDS_FULLSCREEN 4										// Compilers. By Defining It This Way,
#endif															// We Can Avoid Errors

#define DYN_TEXTURE_SIZE	1024

GLuint R2T_ID;

GL_Window*	g_window;
Keys*		g_keys;

// User Defined Variables
float		angle;												// Used To Rotate The Triangles
int			rot1, rot2;											// Counter Variables




BOOL Initialize (GL_Window* window, Keys* keys)					// Any GL Init Code & User Initialiazation Goes Here
{
	g_window	= window;
	g_keys		= keys;

	// Start Of User Initialization
	angle		= 0.0f;											// Set Starting Angle To Zero

	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);						// Black Background
	glClearDepth (1.0f);										// Depth Buffer Setup
	glDepthFunc (GL_LEQUAL);									// The Type Of Depth Testing (Less Or Equal)
	glEnable (GL_DEPTH_TEST);									// Enable Depth Testing
	glShadeModel (GL_SMOOTH);									// Select Smooth Shading
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Set Perspective Calculations To Most Accurate

	glEnable(GL_CULL_FACE);								
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

	// Init Render to texture stuff
	glEnable(GL_TEXTURE_2D);

	// Generate The Texture	
	int texSize = DYN_TEXTURE_SIZE * DYN_TEXTURE_SIZE * 3;

	unsigned int *texData = new unsigned int[texSize];
	
	//ZeroMemory(texData, texSize);
	/*for(int i=0; i < texSize; i++){
		texData[i] = rand()%255;
	}*/
	
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glPixelStorei(GL_PACK_ALIGNMENT, 1);
	
	glGenTextures(1, &R2T_ID);					// Create The Texture
	glBindTexture(GL_TEXTURE_2D, R2T_ID);
	
	glTexImage2D(GL_TEXTURE_2D, 0, 3, DYN_TEXTURE_SIZE, DYN_TEXTURE_SIZE, 0, GL_RGB, GL_UNSIGNED_INT, texData);
	//gluBuild2DMipmaps(GL_TEXTURE_2D, 4, WindowWidth, WindowHeight, GL_RGBA, GL_UNSIGNED_BYTE, texData);

	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtering
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Linear Filtering
	
	delete[] texData;

	return TRUE;												// Return TRUE (Initialization Successful)
}

void Deinitialize (void)										// Any User DeInitialization Goes Here
{
}

void Update (DWORD milliseconds)								// Perform Motion Updates Here
{
	if (g_keys->keyDown [VK_ESCAPE] == TRUE)					// Is ESC Being Pressed?
	{
		TerminateApplication (g_window);						// Terminate The Program
	}

	if (g_keys->keyDown [VK_F1] == TRUE)						// Is F1 Being Pressed?
	{
		ToggleFullscreen (g_window);							// Toggle Fullscreen Mode
	}

	static int factor = 5;
	if(angle > 90.0 && angle <180.0)
		factor = 7;
	else if(angle > 180.0 && angle <360.0)
		factor = 10;
	else 
		factor = 100;
	angle += (float)(((milliseconds) % factor)) / 5.0f;						// Update angle Based On The Clock
	angle = angle>360.0f?0:angle;

	
}



void Draw (void)
{
	glClear (/*GL_COLOR_BUFFER_BIT | */GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer
	//glClearColor(1.0f, 1.0f, 1.0f, 0.5f);				// Black Background	
	glLoadIdentity ();											// Reset The Modelview Matrix
	glTranslatef (0.0f, 0.0f, -6.0f);							// Translate 6 Units Into The Screen
	glRotatef (angle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle

	glDisable(GL_CULL_FACE);

	glPushMatrix();
	for (rot1=0; rot1<2; rot1++)								// 2 Passes
	{
		glRotatef(90.0f,0.0f,1.0f,0.0f);						// Rotate 90 Degrees On The Y-Axis
		glRotatef(180.0f,1.0f,0.0f,0.0f);						// Rotate 180 Degress On The X-Axis
		for (rot2=0; rot2<2; rot2++)							// 2 Passes
		{
			glRotatef(180.0f,0.0f,1.0f,0.0f);					// Rotate 180 Degrees On The Y-Axis
			glBegin (GL_TRIANGLES);								// Begin Drawing Triangles
				glColor3f (1.f, 0.f, 0.f);	glVertex3f( 0.0f, 1.0f, 0.0f);
				glColor3f (0.f, 1.f, 0.f);	glVertex3f(-1.0f,-1.0f, 1.0f);
				glColor3f (0.f, 0.f, 1.f);	glVertex3f( 1.0f,-1.0f, 1.0f);
			glEnd ();											// Done Drawing Triangles
		}
	}
	glPopMatrix();
	
	
	//glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	//glLoadIdentity ();											// Reset The Modelview Matrix
	//glTranslatef (0.0f, 0.0f, -6.0f);							// Translate 6 Units Into The Screen
	//glRotatef (angle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle

	//Render to texture stuff
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, R2T_ID);
		
	
	//glReadPixels(	
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();
			glEnable(GL_DEPTH);
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			//glBlendFunc(GL_SRC_ALPHA, GL_ONE);

			//float cl = h;//GetTime();
			//static float iii = 0;
			//float r = (float)(128.0+127.0*sin(iii*M_PI/64.0+cl/133.0));
			//float g = (float)(128.0-127.0*cos(iii*M_PI/128.0+cl/61.0));
			//float b = (float)(128.0+127.0*sin(iii*M_PI/64.0+cl/72.0));
			//iii++;

			//glColor4f(r/256,g/256,b/256,0.3f);
						
			static float dd = 0.0;//h/512.0;
			static float zz = 0.025;
			float ww = (float)WindowWidth/DYN_TEXTURE_SIZE;
			float hh = (float)WindowHeight/DYN_TEXTURE_SIZE;
			
			if(g_keys->keyDown[VK_UP]){
				zz += 0.001;
			}

			if(g_keys->keyDown[VK_DOWN]){
				zz -= 0.001;
			}

			if(g_keys->keyDown[VK_LEFT]){
				dd += 0.001;
			}

			if(g_keys->keyDown[VK_RIGHT]){
				dd -= 0.001;
			}

			
			glColor4f(1.0, 1.0, 1.0,0.25);
			glBegin(GL_QUADS);			
				glTexCoord2f(0.0-dd, hh-dd);  glVertex3f(0, 0, ZNEAR_2D_FIX);
				glTexCoord2f(0.0-dd, 0.0+dd);  glVertex3f(0, WindowHeight, ZNEAR_2D_FIX);
				glTexCoord2f(ww+dd, 0.0+dd);  glVertex3f(WindowWidth, WindowHeight, ZNEAR_2D_FIX);
				glTexCoord2f(ww+dd, hh-dd);  glVertex3f(WindowWidth, 0, ZNEAR_2D_FIX);
			glEnd();
			
			glColor4f(0.0, 0.0, 0.0,zz);
			//glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
			glBegin(GL_QUADS);			
				glVertex3f(0, 0, ZNEAR_2D_FIX);
				glVertex3f(0, WindowHeight, ZNEAR_2D_FIX);
				glVertex3f(WindowWidth, WindowHeight, ZNEAR_2D_FIX);
				glVertex3f(WindowWidth, 0, ZNEAR_2D_FIX);
			glEnd();
			//glScalef(1.0, 1.0, 1.0);
			
			glDisable(GL_BLEND);
			glDisable(GL_DEPTH);

			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glDisable(GL_TEXTURE_2D);

	
	

	// Update texture stuff
	glEnable(GL_TEXTURE_2D);
	//glFlush();
	glBindTexture(GL_TEXTURE_2D, R2T_ID);
	//glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE, 0, 0, DYN_TEXTURE_SIZE, DYN_TEXTURE_SIZE, 0);
	//glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, DYN_TEXTURE_SIZE, DYN_TEXTURE_SIZE, 0);
	glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, WindowWidth, WindowHeight);
	glDisable(GL_TEXTURE_2D);


	


	glFlush ();													// Flush The GL Rendering Pipeline
}
