/** Program coded by:
  * Name		: Domingos Freitas
  * Email       : domingos.freitas@gmail.com
  * Website     : http://www.home.no/uematsuhome
  *
  **/


#include <windows.h>
#include <stdio.h>

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glaux.h>									// Header File For The GLaux Library
#include <gl\glut.h>

#include <math.h>

#include "Utils.h"
#include "glext.h"
#include "wglext.h"
// Declaracao das variaveis

float WHITE[3]		= {1.0, 1.0, 1.0};
float BLACK[3]		= {0.0, 0.0, 0.0};
float GREY[3]		= {0.8, 0.8, 0.8};
float BLUE[3]		= {0.0, 0.0, 1.0};
float DARKBLUE[3]	= {0.0, 0.0, 0.5};
float RED[3]		= {1.0, 0.0, 0.0};
float DARKRED[3]	= {0.5, 0.0, 0.0};
float GREEN[3]		= {0.0, 1.0, 0.0};
float DARKGREEN[3]	= {0.0, 0.5, 0.0};
float YELLOW[3]		= {1.0, 1.0, 0.0};

extern float fovy;
extern float Gratio;
extern float zNear;
extern float zFar;

extern int WindowWidth;
extern int WindowHeight;

// Declaracao das funcoes

void setOrthographicProjection(int w, int h, bool changeOri) {

	glPushMatrix();
	// switch to projection mode
	glMatrixMode(GL_PROJECTION);
	// save previous matrix which contains the 
	//settings for the perspective projection
	glPushMatrix();
	glPushAttrib(GL_LIGHTING_BIT);
	// reset matrix
	glLoadIdentity();
	// set a 2D orthographic projection		
	glOrtho(0, w, 0, h, zNear, zFar);
	if(changeOri){		
		// invert the y axis, down is positive
		glScalef(1, -1, 1);
		// mover the origin from the bottom left corner
		// to the upper left corner
		glTranslatef(0, -h, 0);	
	} 
	glMatrixMode(GL_MODELVIEW);	
	glLoadIdentity();
	glTranslatef(0, 0, ZNEAR_2D_FIX);
	

	//glDisable(GL_LIGHTING);	
}

void resetPerspectiveProjection() {
	// set the current matrix to GL_PROJECTION
	glMatrixMode(GL_PROJECTION);
	// restore previous settings
	glPopMatrix();
	//glScalef(1, 1, 1);
	glPopAttrib();	
	// get back to GL_MODELVIEW matrix
	glMatrixMode(GL_MODELVIEW);
	//glLoadIdentity();
	glPopMatrix();
	
}

// A cool curve which is excellent for fading text
#define io_curve(x) ((x)*(1-(x))*4)

#define START_BAR 80

float BAR = START_BAR;
bool down = true;


// Funcoes para tratar texto

void renderBitmapString(float x, float y, void *font, int sizey, char *string){  
	char *c;
	float actY = y;
	float actX = x;

	float sizeX = glutBitmapWidth(font,string[0]);
	// set position to start drawing fonts
	glRasterPos3f(actX, actY, ZNEAR_2D_FIX);
	// loop all the characters in the string
	for (c=string; *c != '\0'; c++) {
		if(*c == '\n'){
			actY += sizey;
			actX = x;
			glRasterPos3f(actX, actY, ZNEAR_2D_FIX);
			//c++;
		}else if(*c == '\t'){
			actX += 4 * sizeX;
			glRasterPos3f(actX, actY, ZNEAR_2D_FIX);
			//c++;
		}else {
			glutBitmapCharacter(font, *c);
			actX += sizeX;
		}
	}
}

void printText(float x, float y, void *font, int sizey, char *string, int vpW, int vpH){	
	setOrthographicProjection(vpW, vpH, true);
	glPushMatrix();
	glLoadIdentity();			
	renderBitmapString(x,y,font,sizey,string);	
	glPopMatrix();
	resetPerspectiveProjection();
}


void setBackground(){
	glMatrixMode(GL_TEXTURE);
		glPushMatrix();
		glLoadIdentity();
		glRotatef(180, 0.0,0.0,1.0 );
		glRotatef(180, 0.0,1.0,0.0 );
	glMatrixMode(GL_MODELVIEW);	
}

void resetBackground(){
	glMatrixMode(GL_TEXTURE);
		glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
}

// Funcao auxiliar para calcular o valor em potencia de 2 para a textura dinamica.
int AlignToPow2(int size){
	return 1 << int(ceil(log((double)size)/log(2.0)));
}

// Funcao que preenche a textura dinamica com um texto usando 'render to texture'.
void fillTextOnTexture( GLuint tex, int fntsizey, void *font,char *string, float cl[3]){
	GLsizei vpW, vpH;
//	GLubyte *data;
	int tam = 0;
	float sizex = 0.0;

	
	
	sizex = glutBitmapWidth(font,string[0]) * strlen(string);

	vpH = AlignToPow2(fntsizey);
	vpW = AlignToPow2(sizex);
	
	//printf("%d - %d.\n", vpW, vpH);

	glClearColor(0.0f,0.0f,0.0f,0.0f);	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);    	
	
	glPushMatrix();				
		glViewport(0,0,vpW,vpH);

		glColor4f( cl[0], cl[1], cl[2], 1.0);	

		// Imprimir o texto.				
		printText(0, fntsizey + ((vpH - fntsizey)>>2), font, fntsizey, string, vpW, vpH);	//fntsizey + ((vpH - fntsizey)>>2)		
		//glutWireSphere(1,30,30);
		glBindTexture(GL_TEXTURE_2D, tex);			// Bind To Texture

		glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0.0, 0.0, vpW, vpH, 0);

		
		//data = (GLubyte *)malloc(vpW*vpH*4*sizeof(GLubyte));

		//glReadPixels(0.0, 0.0, vpW, vpH, GL_RGB, GL_UNSIGNED_BYTE, data );
		//glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGBA, vpW, vpH, 0, GL_RGB, GL_UNSIGNED_BYTE, data );
		////glTexSubImage2D(GL_TEXTURE_2D, 0, 0.0, 0.0, vpW, vpH, GL_RGB, GL_UNSIGNED_BYTE, data );
		//free(data);
		glDisable(GL_TEXTURE_2D);
        
		
	    //glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0,vpW,vpH, 0);
	
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 

		glViewport(0 , 0, WindowWidth , WindowHeight);
		
		
	 glPopMatrix();
		
}

// dar as coordenadas da textura
void SetTextureCoord(float x, float z, float xmax, float ymax, bool reflect)
{
	// Find the (u, v) coordinate for the current vertex
	int xx, zz;
	float lamb = 0.0;
	//float u, v, w, Xoffset, Zoffset;
	
	//CVector3 e, n, r;
	double angle = 0.0;
	//float ma, mb;

	float du = 1.0f / xmax;
	float dv = 1.0f / ymax;//(HEIGHT-2*BAR);
	float u =  (float)x * du;/// (float)wpW;
	float v = (float)z * dv; /// (float)wpH;	


	//static float tcicle = 0;
	//tcicle += 0.0000015f;
    xx = x; zz = z;
	
	//Xoffset = wave[xx-1][zz][actBuffer] - wave[xx+1][zz][actBuffer];
	//Zoffset = wave[xx][zz-1][actBuffer] - wave[xx][zz+1][actBuffer];

	if(!reflect){
		
		/*lamb = wave[xx][zz][actBuffer]/(normais[xx][zz][1]);
		u = xx + lamb * (normais[xx][zz][0]);
		v = zz + lamb * (normais[xx][zz][2]);*/
	
		//u = xx+Xoffset;
		//v = zz+Zoffset;
		glTexCoord2f(u,v);	

	}else{		
	/*	n.x = normais[xx][zz][0];	n.y = normais[xx][zz][1];	n.z = normais[xx][zz][2];

		e = Camera.View() - Camera.Position();
	
		r = (e - (n * Dot(n,e) * 2));

		
		u = xx + Xoffset * (r.x);
		v = zz + Zoffset * (r.z);
		w = (wLevel+17) + wave[xx][zz][actBuffer] * r.y;
		//glColor4f(1.0f, 1.0f, 1.0f, fresnelCoef(angle, Air, Water));				// water color
		//glTexCoord3f(r.x,lamb,r.z);		
		glTexCoord3f(u,w,v);		
		//glTexCoord2f(u,v);*/		
	}
}

//====================================================================
//  Using strstr for extension search can result in false positives
//  because of substring matches. Since extension names in the
//  extension string are separated by spaces, this can be fixed simply
//  by looking for a space OR the end-of-string character immediately
//  following the extension we're looking for (by skipping ahead 'len'
//  characters).
//====================================================================
BOOL IsExtensionSupported(const char *checkExtension){
    const char  *s;
	GLint len;

	s = (const char*)glGetString (GL_EXTENSIONS);
	len = strlen (checkExtension);

	while ((s = strstr (s, checkExtension)) != NULL) {
		s += len;

		if ((*s == ' ') || (*s == '\0')) {
			return (TRUE);
		}
	}

	return (FALSE);
}

// WGLisExtensionSupported: This Is A Form Of The Extension For WGL
BOOL IsWExtensionSupported(const char *extension)
{
	const size_t extlen = strlen(extension);
	const char *supported = NULL;

	// Try To Use wglGetExtensionStringARB On Current DC, If Possible
	PROC wglGetExtString = wglGetProcAddress("wglGetExtensionsStringARB");

	if (wglGetExtString)
		supported = ((char*(__stdcall*)(HDC))wglGetExtString)(wglGetCurrentDC());

	// If That Failed, Try Standard Opengl Extensions String
	if (supported == NULL)
		supported = (char*)glGetString(GL_EXTENSIONS);

	// If That Failed Too, Must Be No Extensions Supported
	if (supported == NULL)
		return false;

	// Begin Examination At Start Of String, Increment By 1 On False Match
	for (const char* p = supported; ; p++)
	{
		// Advance p Up To The Next Possible Match
		p = strstr(p, extension);

		if (p == NULL)
			return FALSE;															// No Match

		// Make Sure That Match Is At The Start Of The String Or That
		// The Previous Char Is A Space, Or Else We Could Accidentally
		// Match "wglFunkywglExtension" With "wglExtension"

		// Also, Make Sure That The Following Character Is Space Or NULL
		// Or Else "wglExtensionTwo" Might Match "wglExtension"
		if ((p==supported || p[-1]==' ') && (p[extlen]=='\0' || p[extlen]==' ')){			
			return TRUE;															// Match
		}
	}
}

static int prevVSyncValue;

BOOL setVSync(int interval){

	BOOL res = FALSE;

	PFNWGLSWAPINTERVALEXTPROC wglSwapIntervalEXT = 0;
	PFNWGLGETSWAPINTERVALEXTPROC wglGetSwapIntervalEXT = 0;
    

	if(!IsExtensionSupported("WGL_EXT_swap_control") &&	!IsWExtensionSupported("WGL_EXT_swap_control")){		
		res = FALSE;
	} else {
        wglSwapIntervalEXT = (PFNWGLSWAPINTERVALEXTPROC)wglGetProcAddress( "wglSwapIntervalEXT" );
		wglGetSwapIntervalEXT = (PFNWGLGETSWAPINTERVALEXTPROC)wglGetProcAddress( "wglGetSwapIntervalEXT" );

		//if( wglGetSwapIntervalEXT ){
		//	//vsyncPrev = wglGetSwapIntervalEXT();
		//	char str[1024] = "";
		//	sprintf(str, "VSync: %d", wglGetSwapIntervalEXT());
		//	
		//	MessageBox(NULL, str, "info", MB_OK);
		//}

		if( wglGetSwapIntervalEXT && wglSwapIntervalEXT ){
			prevVSyncValue = wglGetSwapIntervalEXT();
            res = wglSwapIntervalEXT(interval);
		}

		//if( wglGetSwapIntervalEXT ){

		//	char str[1024] = "";
		//	sprintf(str, "VSync: %d", wglGetSwapIntervalEXT());
		//	
		//	MessageBox(NULL, str, "info", MB_OK);
		//}

    }

	return res;
}

BOOL resetVSync(){
    BOOL res = FALSE;

	PFNWGLSWAPINTERVALEXTPROC wglSwapIntervalEXT = 0;
	PFNWGLGETSWAPINTERVALEXTPROC wglGetSwapIntervalEXT = 0;
    

	if(!IsExtensionSupported("WGL_EXT_swap_control") &&	!IsWExtensionSupported("WGL_EXT_swap_control")){		
		res = FALSE;
	} else {
        wglSwapIntervalEXT = (PFNWGLSWAPINTERVALEXTPROC)wglGetProcAddress( "wglSwapIntervalEXT" );
		wglGetSwapIntervalEXT = (PFNWGLGETSWAPINTERVALEXTPROC)wglGetProcAddress( "wglGetSwapIntervalEXT" );

		if( wglSwapIntervalEXT ){			
            res = wglSwapIntervalEXT(prevVSyncValue);
		}
    }

	return res;
}


AUX_RGBImageRec *LoadBMP(char *Filename)                // Loads A Bitmap Image
{
    FILE *File=NULL;                                // File Handle
    if (!Filename)                                  // Make Sure A Filename Was Given
    {
            return NULL;                            // If Not Return NULL
    }
    File=fopen(Filename,"r");                       // Check To See If The File Exists
    if (File)                                       // Does The File Exist?
    {
            fclose(File);                           // Close The Handle
            return auxDIBImageLoad(Filename);       // Load The Bitmap And Return A Pointer
    }
    return NULL;                                    // If Load Failed Return NULL
}

BOOL LoadGLTexture(GLenum target, GLuint *texture, char *Filename )                                    // Load Bitmaps And Convert To Textures
{
    int Status=FALSE;                               // Status Indicator
    AUX_RGBImageRec *TextureImage[1];               // Create Storage Space For The Textures
    memset(TextureImage,0,sizeof(void *)*1);        // Set The Pointer To NULL

    if (TextureImage[0]=LoadBMP(Filename))  {
        Status=TRUE;                            // Set The Status To TRUE
        glGenTextures(1, texture);          // Create Five Textures
	    
		glBindTexture(target, *texture);
		glTexParameteri(target,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(target,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexImage2D(target, 0, GL_RGB, TextureImage[0]->sizeX, TextureImage[0]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[0]->data);
		
		free(TextureImage[0]->data);	// Free The Texture Image Memory
		free(TextureImage[0]);				// Free The Image Structure
    }

    return Status;                                  // Return The Status
}

BOOL CreateDynTexture(GLenum target, GLuint *texture, BOOL mipmaps, int width, int height ){
	int Status=FALSE;                               // Status Indicator
    unsigned char* texData = new unsigned char[sizeof(unsigned char) * width * height * 4];
    
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glPixelStorei(GL_PACK_ALIGNMENT, 1);

    glGenTextures(1, texture);          // Create Five Textures
	
	glBindTexture(target, *texture);
	glTexParameteri(target,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(target,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	if(!mipmaps){
		glTexImage2D(target, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, texData);
	} else {
		gluBuild2DMipmaps(target, GL_RGBA, width, height, GL_RGBA, GL_UNSIGNED_BYTE, texData);
	}
	
	delete[] texData;	// Free The Texture Image Memory		
	Status=TRUE;                            // Set The Status To TRUE
    

    return Status;                                  // Return The Status
}



//Graphics Hardware stuff

// Obtain the vendor of the graphic card.
GFX_CARD_VENDORS GetGFXCardVendor(){
	GFX_CARD_VENDORS res = GFX_COMPATIBLE;

	// Obtain the vendor of the graphic card using a GL call.
	char* vendor = strdup((char *)glGetString(GL_VENDOR));
	vendor = strupr(vendor);
	
	// Compare to the most known graphic card vendors
	if(strstr(vendor, "NVIDIA")){
		res = GFX_NVIDIA;
	} else if(strstr(vendor, "ATI")){
		res = GFX_ATI;
	} else if(strstr(vendor, "MATROX")){
		res = GFX_MATROX;	
	} else if(strstr(vendor, "INTEL")){
		res = GFX_INTEL;
	}

	// Release the memory. (since strdup was used)
	free(vendor);

	// Return the HW vendor.
    return res;
}
