/** Program coded by:
  * Name		: Domingos Freitas
  * Email       : domingos.freitas@gmail.com
  * Website     : http://www.home.no/uematsuhome
  *
  **/


#pragma once
#ifndef _UTILS_H
#define _UTILS_H

#include <windows.h>
#include <stdio.h>

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glaux.h>									// Header File For The GLaux Library
#include <gl\glut.h>

// Extensions
#define GL_TEXTURE_RECTANGLE	0x84F5


#define ZNEAR_2D_FIX	-zNear

// To convert from glut miliseconds to seconds
#define ToSeconds(x) (x/1000.0)
#define ToMinutes(x) (x/1000.0)/60

// A cool curve which is excellent for fading text
#define io_curve(x) ((x)*(1-(x))*4)

// A cool curve which is excellent for fading in or out  the screen
#define P_o_curve(x, sht) (((x+sht)/2.0)*(1.0-((x+sht)/2.0))*4.0)

// A cool curve which is excellent for slide something down
#define down_curve(x) (x/10)
#define up_curve(x) (-x/10)

#define curve(x) exp(x-1.0)*exp(x-1.0)*exp(x-1.0)

// Fades in & out during the given time frame
// a -> actTime , x -> howLong
#define fade_io(a, x) (io_curve(a/x))
#define fade_in(a, x) (P_o_curve((a/x), 0))
#define fade_out(a, x) (P_o_curve((a/x), 1))
#define goDown(a,x) (down_curve(a/x))
#define goUp(a,x) (up_curve(a/x))

// Funcoes
void setBackground();
void resetBackground();

void resetPerspectiveProjection();
void setOrthographicProjection(int w, int h, bool change0ri);

void closeScreen();
void fadeScreen(int io, float scl[3], float time, float howlong);

void renderBitmapString(float x, float y, void *font, int sizey, char *string);
void printText(float x, float y, void *font, int sizey, char *string, int vpW, int vpH);

int AlignToPow2(int size);
void SetTextureCoord(float x, float z, float xmax, float ymax, bool reflect);
void fillTextOnTexture( GLuint tex, int fntsizey, void *font,char *string, float cl[3]);

BOOL IsExtensionSupported(const char *checkExtension);
BOOL IsWExtensionSupported(const char *extension);

enum VSYNC_CONTROL{
	VSYNC_OFF,
	VSYNC_ON
};

BOOL setVSync(int interval);
BOOL resetVSync();

BOOL LoadGLTexture(GLenum target, GLuint *texture, char *Filename );
BOOL CreateDynTexture(GLenum target, GLuint *texture, BOOL mipmaps, int width, int height);

//Graphics Hardware stuff
enum GFX_CARD_VENDORS {
	GFX_COMPATIBLE,
	GFX_NVIDIA,
	GFX_ATI,
	GFX_MATROX,
	GFX_INTEL	
};

GFX_CARD_VENDORS GetGFXCardVendor();


#endif
