#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <stdarg.h>			// Header File For Variable Argument Routines

#include "fonts.h"

//HWND  g_hWnd;											// This is the handle for the window
//RECT  g_rRect;											// This holds the window dimensions
HDC   g_hDC;											// General HDC - (handle to device context)
//HGLRC g_hRC;											// General OpenGL_DC - Our Rendering Context for OpenGL
//HINSTANCE g_hInstance;									// This holds the global hInstance for UnregisterClass() in DeInit()


UINT g_FontListID = 0;

#define MAX_CHARS	256									


#define FONT_EXTRUDE	0.5f

GLYPHMETRICSFLOAT g_GlyphInfo[MAX_CHARS];		

///////////////////////////////// CREATE OPENGL 2D FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This function creates a 2D windows font like "Arial", and returns a display list ID
/////
///////////////////////////////// CREATE OPENGL 2D FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*


UINT CreateOpenGL2DFont(HDC winDC, LPSTR strFontName, int fHeight, int fWeight)		// Build Our Bitmap Font
{
	HFONT hOldFont,hFont;	

	UINT	fontListID = 0;								// This will hold the base ID for our display list

	fontListID = glGenLists(MAX_CHARS);					// Storage For 96 Characters ( NEW )

 
	hFont = CreateFont(	-1*fHeight,				// Height Of Font ( NEW )   
 							  0,				// Width Of Font
   							  0,				// Angle Of Escapement
							  0,				// Orientation Angle
						 fWeight,				// Font Weight
						  FALSE,				// Italic
						  FALSE,				// Underline
						  FALSE,				// Strikeout
  				   ANSI_CHARSET,  			    // Character Set Identifier
                  OUT_TT_PRECIS,				// Output Precision
		    CLIP_DEFAULT_PRECIS,				// Clipping Precision
		    ANTIALIASED_QUALITY,				// Output Quality
      FF_DONTCARE|DEFAULT_PITCH,				// Family And Pitch
		  			strFontName);				// Font Name

	if(!hFont){
		MessageBox(NULL, "Create Font: Error creating font.", "Error", MB_OK);
		return -1;
	}

	hOldFont = (HFONT)SelectObject(winDC, hFont);		// Selects The Font We Want
	wglUseFontBitmaps(winDC, 0, MAX_CHARS - 1, fontListID);			// Builds 96 Characters Starting At Character 32
	SelectObject(winDC, hOldFont);						// Select the old font back in so we don't have memory leaks
	DeleteObject(hFont);
	
	return fontListID;
}


///////////////////////////////// CREATE OPENGL 3D FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This function creates a 3D windows font like "Arial", and returns a display list ID
/////
///////////////////////////////// CREATE OPENGL 3D FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*

UINT CreateOpenGL3DFont(HDC winDC, LPSTR strFontName, int fHeight, int fWeight, float extrude)	
{
	HFONT hOldFont,hFont;	

	UINT	fontListID = 0;								// This will hold the base ID for our display list

	// Here we generate the lists for each character we want to use.
	// This function then returns the base pointer, which will be 1 because
	// we haven't created any other lists.  If we generated another list after
	// this, the base pointer would be at 257 since the last one used was 256 (which is MAX_CHARS)
	fontListID = glGenLists(MAX_CHARS);					// Generate the list for the font

	// Now we actually need to create the font.  We use a windows function called:
	// CreateFont() that returns a handle to a font (HFONT).  Our CreateOpenGLFont()
	// function allows us to pass in a name and height.  For simplistic reasons, I left
	// other options out, but feel free to add them to your function (like bold, italic, width..)
	// In the last tutorial we passed in a height, now we pass in a extrude value.  This
	// value basically makes the thickness in 3D.  The height parameter in CreateFont() doesn't
	// matter now, so it doesn't really matter what value we put in, it is just ignored by wglUseFontOutlines().

	hFont = CreateFont(	-1*fHeight,						// This HEIGHT parameter is ignored by wglUseFontOutlines(). Use glScalef()
						0,								// The WIDTH (If we leave this zero it will pick the best width depending on the height)
						0,								// The angle of escapement
						0,								// The angle of orientation
						fWeight,						// The font's weight (We want it bold)
						FALSE,							// Italic - We don't want italic
						FALSE,							// Underline - We don't want it underlined
						FALSE,							// Strikeout - We don't want it strikethrough
						ANSI_CHARSET,					// This is the type of character set
						OUT_TT_PRECIS,					// The Output Precision
						CLIP_CHARACTER_PRECIS,			// The Clipping Precision
						ANTIALIASED_QUALITY,			// The quality of the font - We want anitaliased fonts
						FF_DONTCARE|DEFAULT_PITCH,		// The family and pitch of the font.  We don't care.
						strFontName);					// The font name (Like "Arial", "Courier", etc...)

	// Now that we have created a new font, we need to select that font into our global HDC.
	// We store the old font so we can select it back in when we are done to avoid memory leaks.
	hOldFont = (HFONT)SelectObject(winDC, hFont);

	// This is the function that creates all the magic.  This will actually output the
	// polygons into our display lists, which creates the outlined characters.
	// But first, we need to give it our desired information.
	// One new thing from the last tutorial is GLYPH's.  A glyph is a 3D character.
	// The GLYPHMETRICSFLOAT structure used holds information about that 3D character,
	// such as it's width and height in 3D units, as well as orientation within it's bounding box.
	// We can use this information if we want to find out how long our sentences are in actual
	// unit lengths, not pixel length.
	glCullFace(GL_BACK); 
	glEnable(GL_CULL_FACE); 
	
	//glPolygonMode(GL_FRONT, GL_LINE);
	wglUseFontOutlines(	winDC,							// This is the global HDC with the desired font selected.
						0,								// This is the starting ASCII value.
						MAX_CHARS - 1,					// This is the ending ASCII value to use (255 is the last).
						fontListID,						// This is the base pointer of our display list we wish to use.
						0,								// This is the deviation from a true outline (floating point)
						extrude,						// This is the extrude value, or in other words, the thickness in Z.
						WGL_FONT_POLYGONS,				// We specify here that we want it rendered in polygons rather than lines
						g_GlyphInfo);					// The address to the buffer that will hold the 3D font info for each character.

	//glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glDisable(GL_CULL_FACE); 
/////// * /////////// * /////////// * NEW * /////// * /////////// * /////////// *

	SelectObject(winDC, hOldFont);						// Select the old font back in so we don't have memory leaks
	DeleteObject(hFont);

	return fontListID;									// Return the ID to the display list to use later
}


/////// * /////////// * /////////// * NEW * /////// * /////////// * /////////// *

void glDraw2DText(const char *strString, ...)				// Custom GL "Print" Routine
{
	char		text[256];				// Holds Our String
	va_list		ap;					// Pointer To List Of Arguments

	if (strString == NULL)					// If There's No Text
		return;						// Do Nothing

	va_start(ap, strString);					// Parses The String For Variables
	    vsprintf(text, strString, ap);				// And Converts Symbols To Actual Numbers
	va_end(ap);						// Results Are Stored In Text

	glPushAttrib(GL_LIST_BIT);				// Pushes The Display List Bits		( NEW )
	glListBase(g_FontListID);					// Sets The Base Character to 32	( NEW )

	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text	( NEW )
	glPopAttrib();						// Pops The Display List Bits	( NEW )

	return;
}
///////////////////////////////// GL DRAW 3D TEXT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This draws 3D text onto the screen using OpenGL.
/////
///////////////////////////////// GL DRAW 3D TEXT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
void glDraw3DText(const char *strString, ...)
{
	float		length=0;								// Used To Find The Length Of The Text
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (strString == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, strString);									// Parses The String For Variables
	    vsprintf(text, strString, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{
		length+=g_GlyphInfo[text[loop]].gmfCellIncX;			// Increase Length By Each Characters Width
	}

	glPushMatrix();

	glTranslatef(-length/2,0.0f,0.0f);					// Center Our Text On The Screen

	glPushAttrib(GL_LIST_BIT | GL_LIGHTING_BIT);							// Pushes The Display List Bits
	//glDisable(GL_LIGHTING);
	glListBase(g_FontListID);		// Sets The Base Character to 0
	
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	
	glPopAttrib();			
	glPopMatrix();

	return;
}


void glDraw3DTextSpectrum(const char *strString,unsigned char *wave, ...)
{
	float		length=0;								// Used To Find The Length Of The Text
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (strString == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, strString);									// Parses The String For Variables
	    vsprintf(text, strString, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{
		length+=g_GlyphInfo[text[loop]].gmfCellIncX;			// Increase Length By Each Characters Width
	}

	glPushMatrix();

	glTranslatef(-length/2,0.0f,0.0f);					// Center Our Text On The Screen

	glPushAttrib(GL_LIST_BIT | GL_LIGHTING_BIT);							// Pushes The Display List Bits
	//glDisable(GL_LIGHTING);
	glListBase(g_FontListID);		// Sets The Base Character to 0
	float val = 0;
	int i = 0;
	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{		
		val = (float)wave[i]/255.0;
		glTranslatef(0.0f,val,0.0f);
		//glRotatef(wave[i]/3, 0.0, 1.0, 0.0);
		glCallLists(1, GL_UNSIGNED_BYTE, &text[loop]);	// Draws The Display List Text
		//glRotatef(-wave[i]/3, 0.0, 1.0, 0.0);
		glTranslatef(0.0f,-val,0.0f);
		i += 2;
		//glTranslatef(g_GlyphInfo[text[loop]].gmfCellIncX,0.0f,0.0f);
	}

	
	glPopAttrib();

	glPopMatrix();

	return;
}


void glDraw3DTextWave(const char *strString,char *wave, ...)
{
	float		length=0;								// Used To Find The Length Of The Text
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (strString == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, strString);									// Parses The String For Variables
	    vsprintf(text, strString, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{
		length+=g_GlyphInfo[text[loop]].gmfCellIncX;			// Increase Length By Each Characters Width
	}


	glPushMatrix();

	glTranslatef(-length/2,0.0f,0.0f);					// Center Our Text On The Screen

	glPushAttrib(GL_LIST_BIT | GL_LIGHTING_BIT);							// Pushes The Display List Bits
	//glDisable(GL_LIGHTING);
	glListBase(g_FontListID);		// Sets The Base Character to 0
	float val = 0;
	int i = 0;
	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{		
		val = (float)wave[i]/255.0;
		glTranslatef(0.0f,val,0.0f);
		glRotatef(wave[i]/3.0, 0.0, 1.0, 0.0);
		glCallLists(1, GL_UNSIGNED_BYTE, &text[loop]);	// Draws The Display List Text
		glRotatef(-wave[i]/3.0, 0.0, 1.0, 0.0);
		glTranslatef(0.0f,-val,0.0f);
		i += 2;
		//glTranslatef(g_GlyphInfo[text[loop]].gmfCellIncX,0.0f,0.0f);
	}

	
	glPopAttrib();

	glPopMatrix();
	return;
}


///////////////////////////////// DESTROY FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This function frees our display lists
/////
///////////////////////////////// DESTROY FONT \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*

void DestroyFont()										
{

	glDeleteLists(g_FontListID, MAX_CHARS);				// Free the display list

	return;
}


///////////////////////////////// INIT GAME WINDOW \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	This function initializes the game window.
/////
///////////////////////////////// INIT GAME WINDOW \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*

void InitFont(HDC winDC, char *fName, int fHeight, int fWeight, bool is3D)
{	
	if(is3D){
		g_FontListID = CreateOpenGL3DFont(winDC, fName, fHeight, fWeight, FONT_EXTRUDE);
	} else {
		g_FontListID = CreateOpenGL2DFont(winDC, fName, fHeight, fWeight);
	}

	// Because we are doing 3D, we need to enable depth testing.  This allows it so
	// the polygons are drawn in the order they are seen.

	//glEnable(GL_DEPTH_TEST);							// Enable depth testing 

	return;
}