#include <windows.h>
#include <stdio.h>
#include <iostream>

#define _USE_MATH_DEFINES
#include <math.h>


//#include "stdafx.h"

#include <list>

#include "CTaskList.h"
#include "CAltTabData.h"

#include "WinFunctions.h"
#include "Utils.h"

#define ToRads(v)	((v*M_PI)/180.0)

CAltTabData::CAltTabData(){

	Initialize();		
	return;
}

CAltTabData::~CAltTabData(){	
	
	Reset();
	return;
}

BOOL CAltTabData::Initialize(){
	this->m_tasks = new CTaskList();	
	this->m_tasks->fillTaskList();
	this->m_nTasks = this->m_tasks->getNrTasks();
	this->m_selectedTaskIdx = 0;
	this->m_unitAngle = 360.0 / this->m_nTasks;
	this->m_displayAngle = 0.0;
	// Calculate Displacement
	this->calculateDisplacement();
	this->m_drawDisplacement = SHAPE_WIDTH * 2.0 + 1.5 * this->m_displacement;
	
	this->calculateDrawingOrder();
	//Create the Textures	
	this->m_taskTextures = new unsigned int[this->m_nTasks];//(unsigned int *)malloc(this->m_nTasks * sizeof(unsigned int));
	this->createWindowsTaskTextures();

	return TRUE;
}

BOOL CAltTabData::Reset(){
	//Delete the Preview Textures
	// ...

	glDeleteTextures(this->m_nTasks, this->m_taskTextures);
	delete [] this->m_taskTextures;
	
	delete this->m_tasks;
	this->m_tasks = NULL;
	this->m_nTasks = 0;
	this->m_drawDisplacement = this->m_displacement = 0.0;

	return TRUE;
}

void CAltTabData::createWindowsTaskTextures(){
	for(int i = 0; i < this->m_nTasks; i++){
		CTaskInfo tf = this->m_tasks->taskList[i];
		CreateWindowTexture(GL_TEXTURE_RECTANGLE, &this->m_taskTextures[i], tf.taskPv, tf.taskWidth, tf.taskHeight );		
	}

	return;
}

void CAltTabData::calculateDrawingOrder(){
	int actIdx = this->m_selectedTaskIdx;
	int nTasks = this->m_nTasks;
	int auxp = -1, auxn = -1;
	int counter = 0, level = 0;

	this->m_drawOrder.clear();
	
	this->m_drawOrder.push_back(actIdx);
	level++;
	counter++;

	while(counter < nTasks){
		auxp = (actIdx + level)%nTasks;
		auxn = (actIdx - level);
		if(auxn < 0){
			auxn = nTasks - abs(auxn);
		}

		if(auxp != auxn){
			this->m_drawOrder.insert(this->m_drawOrder.begin(), auxp);
			this->m_drawOrder.insert(this->m_drawOrder.begin(), auxn);
			counter += 2;
/*			char str[1024] = "";
			sprintf(str, "(%d) %d - %d\n", level, auxp, auxn);
			MessageBox(NULL, str, "info", MB_OK);
*/		} else {
			this->m_drawOrder.insert(this->m_drawOrder.begin(), auxp);
			counter++;
/*			char str[1024] = "";
			sprintf(str, "(%d) %d \n", level, auxp);
			MessageBox(NULL, str, "info", MB_OK);
*/		}

		level++;
	}
/*
	char str[1024] = "";
	for(int i=0; i<this->m_drawOrder.size(); i++){
		sprintf(str, "%d ",this->m_drawOrder[i]);
		MessageBox(NULL, str, "info", MB_OK);
	}
*/	

	return;
}

void CAltTabData::calculateDisplacement(){
	if(this->m_nTasks < 3){		
		this->m_displacement = 0.01;	
	} else {
		float pab = SHAPE_WIDTH/2.0 ;		
		float alpha = ToRads(this->m_unitAngle/2.0);
		float theta = M_PI_2 - (alpha);
				
		float nb = (pab/(cos(theta)));

		this->m_displacement = SHAPE_WIDTH * sqrt((nb * nb) - ( pab * pab));			

	}
	
	return;
}
