#include <windows.h>
#include <stdio.h>
#include <iostream>

//#include "stdafx.h"

#include <queue>

#include "CTransFX.h"

#include "Utils.h"

void CFX::stepFX(int dt){
	if(/*this->fxAngle <= this->fxTargetAngle ||*/this->fxElapsedTime <= FX_DURATION ){
		this->fxElapsedTime += dt;
		this->fxAngle = this->fxTargetAngle * fade_out(ToSeconds(this->fxElapsedTime), ToSeconds(FX_DURATION));		
	} else {
		this->fxDone = true;
	}

	return;
}

CTransFX::CTransFX(){
	this->fxQueue;// = new queue();
	
	this->runFX = false;

	return;
}

void CTransFX::addFX(float sang, float tang){
	CFX fx;

	fx.fxAngle		 = 0.0;
	fx.fxStartAngle = sang;
	fx.fxTargetAngle = tang;
	fx.fxElapsedTime = 0;
	fx.fxDone		 = false;

	this->fxQueue.push(fx);
	this->runFX = true;

	return;
}

bool CTransFX::updateFX(int dt){
	bool res = false;
	if(!this->actFX.fxDone){
		this->actFX.stepFX(dt);		
		res = true;
	} else if(!this->fxQueue.empty()){
		CFX nfx = this->fxQueue.front();

		this->actFX.fxAngle			= 0.0;
		this->actFX.fxElapsedTime	= 0;
		this->actFX.fxStartAngle	= nfx.fxStartAngle;
		this->actFX.fxTargetAngle	= nfx.fxTargetAngle;
		this->actFX.fxDone			= false;

		this->fxQueue.pop();
		res = true;
	} else {
		this->runFX = false;
	}

	return res;
}