#include <windows.h>											// Header File For Windows
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library

#include "wglext.h"		//WGL extensions
#include "glext.h"		//GL extensions

#include <math.h>

//#include <gl\glut.h>

#include "NeHeGL.h"												// Header File For NeHeGL
#include "Utils.h"
#include "CTaskList.h"
#include "CAltTabData.h"
#include "MyAlt-Tab.h"

#include "WinFunctions.h"
#include "Fonts.h"

#include "FSAA.h"

#include "CConfig.h"

//#include "CTransFX.h"

#pragma comment( lib, "opengl32.lib" )							// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )								// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )								// Search For GLaux.lib While Linking

//#pragma comment( lib, "glut32.lib" )							// Search For Glut.lib While Linking
//#pragma comment( lib, "ComCtl32.lib" )								// Search For GLaux.lib While Linking
//#include <commctrl.h>

#ifndef CDS_FULLSCREEN											// CDS_FULLSCREEN Is Not Defined By Some
#define CDS_FULLSCREEN 4										// Compilers. By Defining It This Way,
#endif															// We Can Avoid Errors

#define DYN_TEXTURE_SIZE	1024

#define FONT_HEIGHT		18

GL_Window*	g_window;
Keys*		g_keys;


/**
 ** User Defined Variables
 ** 
 **/

// Alt-Tab process
HHOOK AltTabHook = NULL;
//extern HOOKPROC LowLevelKBAltTabProc;

// Process List
CAltTabData *procList;

// Transition Effect
//CTransFX transFX;
#define FX_DURATION	500
#define FX_NONE		0
#define FX_RIGHT	-1
#define FX_LEFT		1
bool  fxDone = true;
float fxTargetAngle = 0.0;
int	  fxDirection	= FX_NONE;

// Text
bool usePrettyText	= true;
GLuint textBkTex;

// Background Texture
bool updtBackgroundTexture = false;
UINT_PTR UTTimerID = NULL;

// Texture Filtering
GLfloat maxAnisotropy = 1.0f;

// Motion effect stuff
GLuint R2T_ID;

// Run time
int runTime = 0;

// Graphics Hardware stuff
GFX_CARD_VENDORS gfxVendor = GFX_COMPATIBLE;


/**
 ** User Defined Function Prototipes
 ** 
 ** - Only for functions used internaly, for global scope functions
 **   the function prototypes should be in the 'MyAlt-Tab.h' header
 **   file.
 ** 
 **/

// Background Texture update timer.
void CALLBACK UpdtTexTimerProc(HWND hwnd, UINT message, UINT idTimer, DWORD dwTime);

LRESULT WINAPI LowLevelKBAltTabProc(INT nCode, WPARAM wParam, LPARAM lParam);

void InitDisplayInfo(){

	/** INITIALIZE THE PROCESSES INFORMATION **/
	
	procList = new CAltTabData();

	if(!procList || procList->m_nTasks < 1){
		delete procList;
		procList = NULL;
		ShowWindow(g_window->hWnd, SW_HIDE);	

	} else if(procList->m_nTasks == 1){
        CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
				
		if(!SwitchToWindow(cti.taskPv)){
			SwitchToWindow(cti.task);
		}
		delete procList;
		procList = NULL;
		ShowWindow(g_window->hWnd, SW_HIDE);

	} else {	
		/** INITIALIZE APP TEXTURES AND TEXTURES PARAMS **/ 
		RECT r;	
		GetWindowRect(g_window->hWnd, &r);
				
		CreateBackgroundTexture(GL_TEXTURE_RECTANGLE, &procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);
		
		ShowWindow(g_window->hWnd, SW_SHOW);
		if(!SetForegroundWindow(g_window->hWnd)){
			SetForegroundWindow(g_window->hWnd);
		}		
	}
	g_window->isVisible = IsWindowVisible(g_window->hWnd);

	return;
}

void DeinitDisplayInfo(){
	
	ShowWindow(g_window->hWnd, SW_HIDE);	
	if(procList){
		glDeleteTextures(1, &procList->m_backTexture);
		procList->m_tasks->clearTasks();		
		delete procList;
		procList = NULL;
	}
	g_window->isVisible = IsWindowVisible(g_window->hWnd);

	return;
}


BOOL Initialize (GL_Window* window, Keys* keys)					// Any GL Init Code & User Initialiazation Goes Here
{
	g_window	= window;
	g_keys		= keys;	

	/** CHECK FOR ALL WORKING CONDITIONS **/

	// Check for OS version (Windows XP+) 
	if(CheckOSVersion() == FALSE){
		return FALSE;
	}

	//Check for GL_EXT_texture_rectangle or GL_NV_texture_rectangle	
	if(!IsExtensionSupported("GL_EXT_texture_rectangle") &&	!IsExtensionSupported("GL_NV_texture_rectangle")){
		return FALSE;
	}

	/** GRAPHICS HARDWARE STUFF **/
	gfxVendor = GetGFXCardVendor();


	/** INITIALIZE ALT-TAB KEY COMBINATION CAPTURE AND PROCESS **/
	//AltTabHook = SetWindowsHookEx(WH_KEYBOARD_LL, LowLevelKBAltTabProc, g_window->init.application->hInstance, 0);
	AltTabHook = SetWindowsHookEx(WH_KEYBOARD_LL, LowLevelKBAltTabProc, GetModuleHandle(NULL), 0);
	
	/** SET SOME APPLICATION CONFIGURATIONS **/
	// Use Pretty Text
	usePrettyText	= appConfig.usePrettyText;
	// Update Background texture
	updtBackgroundTexture = appConfig.updtBgTexture;

	/** OPENGL INITIALIZATION **/

	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);						// Black Background
	glClearDepth (1.0f);										// Depth Buffer Setup
	glDepthFunc (GL_LEQUAL);									// The Type Of Depth Testing (Less Or Equal)
	glEnable (GL_DEPTH_TEST);									// Enable Depth Testing
	glShadeModel (GL_SMOOTH);									// Select Smooth Shading
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Set Perspective Calculations To Most Accurate
	
	glEnable(GL_CULL_FACE);					
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	

	/** INITIALIZE FONTS **/
	InitFont(g_window->hDC, "Tahoma", FONT_HEIGHT, FW_HEAVY, false);

	
	/** INITIALIZE COMMON CONTROLS v6.0 **/

	//  This initialization must be done if we need to use
	// functions like 'DrawShadowText' that uses common controls 6.
	// For more information visit MSDN.
	//InitCommonControls();
		

	/** INITIALIZE THE PROCESSES INFORMATION **/
	
	//procList = new CAltTabData();

	/** INITIALIZE APP TEXTURES AND TEXTURES PARAMS **/ 

	//RECT r;	
	//GetWindowRect(g_window->hWnd, &r);
		
	//ShowWindow(g_window->hWnd, SW_HIDE);
	//CreateBackgroundTexture(GL_TEXTURE_RECTANGLE, &procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);
	//ShowWindow(g_window->hWnd, SW_SHOW);	
	//SetForegroundWindow(g_window->hWnd);

	// Load the shadow frame texture
	//if(!LoadGLTexture(GL_TEXTURE_2D, &textBkTex, "data/bg.bmp")){
	//	MessageBox(NULL, "No Text Background texture", "Error", MB_ICONERROR | MB_OK);
	//}

	// Get max Texture Anisotropic filtering
	glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &maxAnisotropy);

    // Set Background Texture update interval (5 seconds). Testing only, buggy effect.
	if(updtBackgroundTexture){
		// set the timer func
		UTTimerID = SetTimer(g_window->hWnd, NULL, 5000, UpdtTexTimerProc);
	}

	/** INITIALIZE ANTIALIASING **/

	// Enables polygon smooth ( Antialiasing ) w/o muiltisample.(NV: causes render bug)
	//glHint (GL_LINE_SMOOTH_HINT, GL_NICEST);	
	//glHint (GL_POLYGON_SMOOTH_HINT, GL_NICEST);	
	//glEnable(GL_LINE_SMOOTH);
	//glEnable(GL_POLYGON_SMOOTH);
	// Sets Full-Scene Antialiasing (muiltisample) hint.
	if(arbMultisampleSupported && gfxVendor == GFX_NVIDIA){
		glHint(GL_MULTISAMPLE_FILTER_HINT_NV, GL_FASTEST);		
	}

	/** VERTICAL SYNC **/
	// Turn V-Sync On 
	setVSync(VSYNC_ON);

	/** MOTION EFFECT STUFF **/
	CreateDynTexture(GL_TEXTURE_RECTANGLE, &R2T_ID, FALSE, WindowWidth, WindowHeight);
	

	return TRUE;												// Return TRUE (Initialization Successful)
}



void Deinitialize (void)										// Any User DeInitialization Goes Here
{

	if(AltTabHook){
		UnhookWindowsHookEx(AltTabHook);
	}

	if(updtBackgroundTexture){
		// unset the timer func
		KillTimer(g_window->hWnd, UTTimerID);
	}

	DeinitDisplayInfo();
	//glDeleteTextures(1, &procList->m_backTexture);
	//glDeleteTextures(1, textBkTex);
	//delete procList;

	// Destroy fonts
	DestroyFont();

	// Vertical Sync
	// Turn V-Sync on so the processor won't be running at 100%
	resetVSync();
}

void Update (DWORD milliseconds)								// Perform Motion Updates Here
{
	runTime += milliseconds;

	if(!IsWindowVisible(g_window->hWnd)){
		g_keys->keyDown[VK_ESCAPE] = FALSE;
		g_keys->keyDown[VK_RETURN] = FALSE;
		g_keys->keyDown[VK_F1] = FALSE;
		g_keys->keyDown['T'] = FALSE;
		g_keys->keyDown[VK_LEFT] = FALSE;
		g_keys->keyDown[VK_RIGHT] = FALSE;

		return;
	}

	if(!fxDone){
		procList->m_displayAngle += (float)fxDirection * ((milliseconds * procList->m_unitAngle) / (float)FX_DURATION);		
		if(((fxDirection == FX_LEFT) && (procList->m_displayAngle >= fxTargetAngle))
			||
		   ((fxDirection == FX_RIGHT) && (procList->m_displayAngle <= fxTargetAngle))){
			procList->m_displayAngle = fxTargetAngle;
			fxTargetAngle = 0.0;
			fxDirection = FX_NONE;
			fxDone = true;
		} 
	}

	if (g_keys->keyDown[VK_ESCAPE] == TRUE)					// Is ESC Being Pressed?
	{
		//TerminateApplication (g_window);						// Terminate The Program		
		DeinitDisplayInfo();
		g_keys->keyDown[VK_ESCAPE] = FALSE;
	}

	if (g_keys->keyDown[VK_RETURN] == TRUE)					// Is ENTER Being Pressed?
	{
		CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
				
		if(!SwitchToWindow(cti.taskPv)){
			SwitchToWindow(cti.task);
		}

		//TerminateApplication (g_window);						// Terminate The Program		
		DeinitDisplayInfo();
		g_keys->keyDown[VK_RETURN] = FALSE;
	}

	if (g_keys->keyDown[VK_F1] == TRUE)						// Is F1 Being Pressed?
	{
		//ToggleFullscreen (g_window);							// Toggle Fullscreen Mode
		aaQuality = 4 - aaQuality;
		g_keys->keyDown[VK_F1] = FALSE;
	}

	if (g_keys->keyDown['T'] == TRUE)						// Is F1 Being Pressed?
	{
		g_keys->keyDown['T'] = FALSE;
		usePrettyText = !usePrettyText;
	}

	if(g_keys->keyDown[VK_LEFT]){		
		if(procList->m_nTasks > 1 && fxDone){			
			procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx+1) % procList->m_nTasks;
			
			fxTargetAngle = procList->m_displayAngle + procList->m_unitAngle;
			fxDirection = FX_LEFT;
			fxDone = false;

			//procList->m_displayAngle += procList->m_unitAngle;//procList->m_selectedTaskIdx * procList->m_unitAngle;
			//procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

			CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
			
			//char str[1024] = "";
			//sprintf(str, "%d - %d",cti.taskWidth, cti.taskHeight);
			SetWindowText(g_window->hWnd, cti.taskText);	
			
			g_keys->keyDown[VK_LEFT] = FALSE;

			procList->calculateDrawingOrder();

		}
	}

	if(g_keys->keyDown[VK_RIGHT]){
		
		if(procList->m_nTasks > 1 && fxDone){		

			if(procList->m_selectedTaskIdx == 0){
				procList->m_selectedTaskIdx = procList->m_nTasks - 1;
			} else {
				procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx-1);
			}
	        
			fxTargetAngle = procList->m_displayAngle - procList->m_unitAngle;
			fxDirection = FX_RIGHT;
			fxDone = false;

			//procList->m_displayAngle -= procList->m_unitAngle;//procList->m_selectedTaskIdx * procList->m_unitAngle;				
			//procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

			CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
			
			//char str[1024] = "";
			//sprintf(str, "%d - %s",procList->m_selectedTaskIdx, cti.taskText);
			SetWindowText(g_window->hWnd, cti.taskText);	

			g_keys->keyDown[VK_RIGHT] = FALSE;

			procList->calculateDrawingOrder();
		}
		
	}
	
    return;
}

void DrawBackground(){
		
	//Render background texture stuff
	glEnable(GL_TEXTURE_RECTANGLE);
	glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_backTexture);
	
	//glReadPixels(	
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();
			
		float zz = -(zFar-zNear);		
						
			//float ww = (float)WindowWidth/1024.0;
			//float hh = (float)WindowHeight/1024.0;
			//glEnable(GL_BLEND);
			glColor4f(1.0, 1.0, 1.0,0.5);
			glBegin(GL_QUADS);			

				glTexCoord2f(0.0, WindowHeight);  glVertex3f(0, 0, zz);
				glTexCoord2f(0.0, 0.0);  glVertex3f(0, WindowHeight, zz);
				glTexCoord2f(WindowWidth, 0.0);  glVertex3f(WindowWidth, WindowHeight, zz);
				glTexCoord2f(WindowWidth, WindowHeight);  glVertex3f(WindowWidth, 0, zz);
			glEnd();
			//glDisable(GL_BLEND);
			
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glDisable(GL_TEXTURE_RECTANGLE);

	glFlush();
}

void DrawTasks(){
	
	glDisable(GL_CULL_FACE);

	glPushMatrix();
	//glTranslatef (0.0f, 0.0f, -10.0f);
	//glRotatef (-90.0, 1.0f, 0.0f, 0.0f);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	for (int t = 0; t< procList->m_nTasks; t++)								// 2 Passes
	{	
		glRotatef(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle,0.0f,1.0f,0.0f);						// Rotate 90 Degrees On The Y-Axis		
		glTranslatef (0.0f, 0.0f, procList->m_displacement);

		float c = (procList->m_drawOrder[t]+1)*procList->m_unitAngle / 360.0;
		
		if(procList->m_drawOrder[t] == procList->m_selectedTaskIdx){
			glColor4f (1.0, 1.0, 1.0, 0.95);	
		} else {
			glColor4f (1.0, 1.0, 1.0, 0.75);	
			//glDepthMask(GL_FALSE);
		}
		CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_drawOrder[t]);

		//glutSolidSphere(0.5, 30,30);		
		glEnable(GL_TEXTURE_RECTANGLE);
		glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_taskTextures[procList->m_drawOrder[t]]);		
		glTexParameterfv(GL_TEXTURE_RECTANGLE, GL_TEXTURE_MAX_ANISOTROPY_EXT, &maxAnisotropy);


		int ww = tInfo.taskWidth;
		int hh = tInfo.taskHeight;

		float ratio = (float)ww / (float)hh;

		float ws = SHAPE_WIDTH;
		float hs = SHAPE_HEIGHT;

		/*if(tInfo.taskIconic){
			ws = hs = 0.5;
		}*/

		if(ratio >= 1){
			hs /= ratio;
		} else {
			ws *= ratio;
		}

		glBegin (GL_QUADS);								// Begin Drawing Triangles
			glTexCoord2f(0.0, hh);   glVertex3f( -ws, hs, 0.0f);
			glTexCoord2f(0.0, 0.0);  glVertex3f(-ws,-hs, 0.0f);
			glTexCoord2f( ww, 0.0);  glVertex3f( ws,-hs, 0.0f);
			glTexCoord2f( ww, hh);   glVertex3f( ws,hs, 0.0f);
		glEnd ();											// Done Drawing Triangles
		

		glDisable(GL_TEXTURE_RECTANGLE);

		//glDepthMask(GL_TRUE);
		glTranslatef (0.0f, 0.0f, -procList->m_displacement);

		glRotatef(-(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle),0.0f,1.0f,0.0f);	
	}
	
	glDisable(GL_BLEND);
	glPopMatrix();

	glEnable(GL_CULL_FACE);	

	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}
//#include "gl/glut.h"

void DrawTaskText(){

	// Fonts
/*	
	RECT r; GetClientRect(g_window->hWnd, &r);

HFONT font = CreateFont(20, 10, 0, 0, FW_BOLD, 0, 0, 0,
  ANSI_CHARSET, OUT_DEVICE_PRECIS, 
  CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH, "Tahoma");

SelectObject(g_window->hDC, font);



SetBkMode(g_window->hDC, TRANSPARENT);


CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
int len = strlen(tInfo.taskText);
WCHAR szText[MAX_TEXT_LENGHT] = L"";
if (!InternalGetWindowText(tInfo.task, szText, MAX_TEXT_LENGHT)){
			InternalGetWindowText(tInfo.taskPv, szText, MAX_TEXT_LENGHT);
}
DrawShadowText(g_window->hDC, szText, len, &r,DT_BOTTOM | DT_CENTER | DT_SINGLELINE | DT_NOPREFIX | DT_END_ELLIPSIS, RGB(255,255,255), RGB(0,0,0), 2, 2);
//DrawText(g_window->hDC, tInfo.taskText, (len <= 50)?len:50, &r, DT_BOTTOM | DT_CENTER | DT_SINGLELINE );


DeleteObject(font); 

*/
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();		
		//glLoadIdentity ();

			CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);

			char txt[65] = "";

			strncpy(txt, tInfo.taskText, 55*sizeof(char));
			if(strlen(tInfo.taskText) > 55){
				txt[51] = txt[52] = txt[53] = '.';
				txt[54] = '\0';
			}

			if(!usePrettyText){

				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glBegin (GL_QUAD_STRIP);								// Begin Drawing Triangles

					glColor4ub(214, 219, 191,0);
					glVertex3f(  0,  0, ZNEAR_2D_FIX);
					glVertex3f(  0, 25, ZNEAR_2D_FIX);				

					glColor4ub(214, 219, 191,245);
					glVertex3f( 15,  0, ZNEAR_2D_FIX);
					glVertex3f( 15, 25, ZNEAR_2D_FIX);				

					glVertex3f(WindowWidth - 15,  0, ZNEAR_2D_FIX);
					glVertex3f(WindowWidth - 15, 25, ZNEAR_2D_FIX);				

					glColor4ub(214, 219, 191,0);
					glVertex3f(WindowWidth,  0, ZNEAR_2D_FIX);
					glVertex3f(WindowWidth, 25, ZNEAR_2D_FIX);				
					
				glEnd ();											// Done Drawing Triangles
				
				glDisable(GL_BLEND);

				//set the text color for the actual text render
				glColor4ub(107, 109, 95,250);
				glRasterPos3f(15.0,FONT_HEIGHT - 0.5, ZNEAR_2D_FIX);
				glDraw2DText(txt);
			
			} else {
				
				//Pretty Text -- Good but requires to much CPU time				
				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glColor4f(0.25, 0.25, 0.25,0.25);

				glRasterPos3f(25+1.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				glRasterPos3f(25+1.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT+2, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				
				glColor4f(0.1, 0.1, 0.1,0.65);			
				glRasterPos3f(25+3.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				glDisable(GL_BLEND);
	
				
				//set the text color and position for the actual text render
				glColor4f(1.0, 1.0, 1.0,1.0);
				glRasterPos3f(25+2.0,FONT_HEIGHT - 0.5, ZNEAR_2D_FIX);
				glDraw2DText(txt);

				
				

/*				// Make a shadow frame around the main window
				glEnable(GL_TEXTURE_2D);
				glBindTexture(GL_TEXTURE_2D, textBkTex);
				glEnable(GL_BLEND);
				glBlendFunc(GL_ZERO, GL_SRC_COLOR);
				glColor4f(1.0, 1.0, 1.0,1.0);
				glBegin (GL_QUADS);								// Begin Drawing Triangles

					glTexCoord2f(0.0f, 0.0f); 
					glVertex3f(  0, WindowHeight, ZNEAR_2D_FIX); 
					glTexCoord2f(1.0f, 0.0f); 
					glVertex3f(WindowWidth, WindowHeight, ZNEAR_2D_FIX);				
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(WindowWidth,  0, ZNEAR_2D_FIX);
					glTexCoord2f(0.0f, 1.0f); 
					glVertex3f(  0,  0, ZNEAR_2D_FIX);									
					
				glEnd ();											// Done Drawing Triangles
				
				glDisable(GL_BLEND);

*/
			}
		
			
			
						
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}

#define GRID_SIZE	5
float dMatU[GRID_SIZE][GRID_SIZE] = 
{
	{0.0,	0.0,	0.0,	0.0,	0.0},
	{0.0,	+0.4,	+0.2,	+0.4,	0.0},
	{0.0,	0.0,	0.0,	0.0,	0.0},
	{0.0,	-0.4,	-0.2,	-0.4,	0.0},
	{0.0,	0.0,	0.0,	0.0,	0.0}
};
float dMatV[GRID_SIZE][GRID_SIZE] = 
{
	{0.0,	0.0,	0.0,	0.0,	0.0},
	{0.0,	+0.4,	0.0,	-0.4,	0.0},
	{0.0,	+0.2,	0.0,	-0.2,	0.0},
	{0.0,	+0.4,	0.0,	-0.4,	0.0},
	{0.0,	0.0,	0.0,	0.0,	0.0}
};

void DrawAndUpdateDynTexture(){

	glFlush();	
	
	//Render to texture stuff
	glEnable(GL_TEXTURE_RECTANGLE);
	glBindTexture(GL_TEXTURE_RECTANGLE, R2T_ID);
		
	
	//glReadPixels(	
	setOrthographicProjection(WindowWidth, WindowHeight, false);
		glPushMatrix();			
			glEnable(GL_DEPTH);
			glEnable(GL_BLEND);
			glDisable(GL_CULL_FACE);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			
			float ww = (float)WindowWidth;
			float hh = (float)WindowHeight;
			
			static float dd = 0.0;
			//dd = (!fxDone)?-1.0:0.0;

			float zpos = -(zFar-zNear);
			glColor4f(1.0, 1.0, 1.0,0.70);
			/*glBegin(GL_QUADS);			
				glTexCoord2f(0.0-dd, hh+dd);  glVertex3f(0, 0, zpos);
				glTexCoord2f(0.0-dd, 0.0-dd);  glVertex3f(0, WindowHeight, zpos);
				glTexCoord2f(ww+dd, 0.0-dd);  glVertex3f(WindowWidth, WindowHeight, zpos);
				glTexCoord2f(ww+dd, hh+dd);  glVertex3f(WindowWidth, 0, zpos);
			glEnd();*/

			for(int y=0; y < GRID_SIZE; y++){
				glBegin(GL_QUAD_STRIP);
				for(int x=0; x < GRID_SIZE; x++){
			
					
					float u0 = (float)x*ww/(float)(GRID_SIZE-1);
					float v0 = (float)y*hh/(float)(GRID_SIZE-1);
					float u1 = u0;
					float v1 = (float)(y + 1)*hh/(float)(GRID_SIZE-1);

					float x0 = u0;
					float y0 = v0;
					float x1 = u1;
					float y1 = v1;

					if(!fxDone){
						float gfxFix = 1.0;
						if(gfxVendor == GFX_ATI){
							gfxFix = 2.0;
						}
						u0 += gfxFix * dMatU[x][y];
						u1 += gfxFix * dMatU[x][y+1];
						v0 += gfxFix * dMatV[x][y];
						v1 += gfxFix * dMatV[x][y+1];
					}
					
					glTexCoord2f(u1, v1);  glVertex3f(x1, y1, zpos);
					glTexCoord2f(u0, v0);  glVertex3f(x0, y0, zpos);
			
					
				}
				glEnd();
			}
						
			glDisable(GL_BLEND);
			glDisable(GL_DEPTH);

			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glDisable(GL_TEXTURE_RECTANGLE);
	
	glFlush();


	// Update texture stuff
	glEnable(GL_TEXTURE_RECTANGLE);
	glBindTexture(GL_TEXTURE_RECTANGLE, R2T_ID);
	//glCopyTexImage2D(GL_TEXTURE_RECTANGLE, 0, GL_DEPTH_COMPONENT, 0, 0,WindowWidth, WindowHeight, 0);
	//glCopyTexImage2D(GL_TEXTURE_RECTANGLE, 0, GL_LUMINANCE, 0, 0, DYN_TEXTURE_SIZE, DYN_TEXTURE_SIZE, 0);
	//glCopyTexImage2D(GL_TEXTURE_RECTANGLE, 0, GL_RGBA, 0, 0, WindowWidth, WindowHeight, 0);
	glCopyTexSubImage2D(GL_TEXTURE_RECTANGLE, 0, 0, 0, 0, 0, WindowWidth, WindowHeight);
	glDisable(GL_TEXTURE_RECTANGLE);

}

void Draw (void)
{
	if(!IsWindowVisible(g_window->hWnd)){
		//Sleep(5);
		return;
	}

	if(!procList || procList->m_nTasks < 1){
		g_keys->keyDown[VK_ESCAPE] = TRUE;
		return;
	}

	glClearColor(0.0f, 0.0f, 0.3f, 0.0f);						// Black Background	
	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer	
	glLoadIdentity ();											// Reset The Modelview Matrix
		
	
	glTranslatef (0.0f, 0.0f, -(procList->m_drawDisplacement));							// Translate 6 Units Into The Screen


	glRotatef (procList->m_displayAngle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle
	
	
	glDisable(GL_MULTISAMPLE_ARB);

	DrawBackground();

	// Drawing the tasks
	if(arbMultisampleSupported && aaQuality != AA_NONE){
		glEnable(GL_MULTISAMPLE_ARB);
	}
	DrawTasks();	

	glDisable(GL_MULTISAMPLE_ARB);
	
	DrawTaskText();


	//Render to texture stuff
	DrawAndUpdateDynTexture();
	
	glFlush ();													// Flush The GL Rendering Pipeline
}

/**
 ** Auxiliary and Low-Level Functions
 **
 **/

//  This method creates a low-level keyboard hook layer globally across the 
// current desktop. The LowLevelKeyboardProc callback function specified in 
// the call to SetWindowsHookEx, receives all keyboard input. 
// The LowLevelKeyboardProc should call CallNextHookEx after processing keyboard 
// input, in order to allow the next hook chain (most likely the destination 
// application) to receive the input. Since the LowLevelKeyboardProc receives 
// all keyboard events, it can easily be implemented as a state machine that listens 
// for the combination of Alt and Tab pressed simultaneously. If the application 
// implements its own AltTab mechanism, it would execute the window enumeration 
// algorithm at this point, and return from the LowLevelKeyboardHook without 
// forwarding the last AltTab key event.

LRESULT WINAPI LowLevelKBAltTabProc(INT nCode, WPARAM wParam, LPARAM lParam)
{	
    static BOOL fShiftPressed = FALSE;

    BOOL fHandled = FALSE;

    if (nCode == HC_ACTION)
    {
        KBDLLHOOKSTRUCT *pkbdllhook = (KBDLLHOOKSTRUCT *)lParam;

        switch (wParam)
        {
			case WM_KEYDOWN:
            case WM_SYSKEYDOWN:
                switch (pkbdllhook->vkCode)
                {
                    case VK_LSHIFT:
                    case VK_RSHIFT:
                    {
                        // the user pressed the shift key
                        fShiftPressed = TRUE;
                        break;
                    }
                    case VK_TAB:
                    {
                        if (pkbdllhook->flags & LLKHF_ALTDOWN)
                        {
                            // the user pressed Alt+Tab, execute AltTab hotkey handler
							//MessageBox(NULL,"Information", "Info", MB_OK);
							if(IsWindowVisible(g_window->hWnd)){
								if(fShiftPressed){
									g_keys->keyDown[VK_LEFT] = TRUE;
								} else {
									g_keys->keyDown[VK_RIGHT] = TRUE;
								}
							} else {
								InitDisplayInfo();								
							}
                            fHandled = TRUE;
                        }
                        break;
                    }
					case VK_LEFT:
                    {
						g_keys->keyDown[VK_LEFT] = TRUE;
						//fHandled = TRUE;
						break;
					}
					case VK_RIGHT:
                    {
						g_keys->keyDown[VK_RIGHT] = TRUE;
						//fHandled = TRUE;
						break;
					}
                    case VK_ESCAPE:
                    {
                        if (pkbdllhook->flags & LLKHF_ALTDOWN)
                        {
                            // the user pressed Escape, end the AltTab container 
                            // window without switching the selected window
							g_keys->keyDown[VK_ESCAPE] = TRUE;
                            fHandled = TRUE;							
                        }
                        break;
                    }
					case 't':
					case 'T':
					{
						g_keys->keyDown['T'] = TRUE;
						//fHandled = TRUE;
						break;
					}
					case VK_F1:
					{
                        g_keys->keyDown[VK_F1] = TRUE;
						//fHandled = TRUE;
						break;
					}

                }

                break;

            case WM_KEYUP:
            case WM_SYSKEYUP:
                switch (pkbdllhook->vkCode)
                {
                    case VK_LMENU:
                    case VK_RMENU:
                    {
                        // the user let go of the Alt key, end the AltTab container
                        // window switching to the selected window
						if(IsWindowVisible(g_window->hWnd)){
							g_keys->keyDown[VK_RETURN] = TRUE;
							//fHandled = TRUE;
						}
                        break;
                    }
                    case VK_LSHIFT:
                    case VK_RSHIFT:
                    {
                        // the user released the shift key
                        fShiftPressed = FALSE;
                        break;
                    }
                }

                break;
        }
    }

    return (fHandled ? TRUE : CallNextHookEx(AltTabHook, nCode, wParam, lParam));

}

// Background Texture update timer
void CALLBACK UpdtTexTimerProc( 
    HWND hwnd,        // handle to window for timer messages 
    UINT message,     // WM_TIMER message 
    UINT idTimer,     // timer identifier 
    DWORD dwTime)     // current system time 
{ 

	RECT r;		
	GetWindowRect(hwnd, &r);

	ShowWindow(hwnd, SW_HIDE);
	Sleep(50);
	UpdateBackgroundTexture(GL_TEXTURE_RECTANGLE, &procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);	
	ShowWindow(hwnd, SW_SHOW);


	return;
} 


