// Needed to use the PrintWindow Function
#define _WIN32_WINNT 0x0501

#include <windows.h>											// Header File For Windows
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library

#include "WinFunctions.h"
#include "Utils.h"


typedef struct _RGBOGL {
		BYTE    rgbRed;
		BYTE    rgbGreen;
        BYTE    rgbBlue;       
        //BYTE    rgbReserved;
} RGBOGL;

typedef struct _RGBAOGL {
		BYTE    rgbRed;
		BYTE    rgbGreen;
        BYTE    rgbBlue;       
        BYTE    rgbAlpha;
} RGBAOGL;

BOOL CheckOSVersion() {
	OSVERSIONINFO vi = { sizeof(OSVERSIONINFO) };
	if (!GetVersionEx(&vi) || vi.dwPlatformId != VER_PLATFORM_WIN32_NT || 
		vi.dwMajorVersion < 5 || vi.dwMinorVersion < 1) {
			MessageBoxA(NULL, "This program requires features present in Windows XP/2003.", 
				"Error", MB_OK | MB_ICONERROR | MB_TOPMOST | MB_SETFOREGROUND);
			return(FALSE);
	}
	return(TRUE);
}

PBITMAPINFO CreateBitmapInfoStruct(HBITMAP hBmp)
{ 
    BITMAP bmp; 
    PBITMAPINFO pbmi; 
    WORD    cClrBits; 

    // Retrieve the bitmap color format, width, and height. 
    if (!GetObject(hBmp, sizeof(BITMAP), (LPSTR)&bmp)) 
		MessageBox(NULL,"CreateBitmapInfoStruct :: GetObject Error", "ERROR", MB_OK);

    // Convert the color format to a count of bits. 
    cClrBits = (WORD)(bmp.bmPlanes * bmp.bmBitsPixel); 
    if (cClrBits == 1) 
        cClrBits = 1; 
    else if (cClrBits <= 4) 
        cClrBits = 4; 
    else if (cClrBits <= 8) 
        cClrBits = 8; 
    else if (cClrBits <= 16) 
        cClrBits = 16; 
    else if (cClrBits <= 24) 
        cClrBits = 24; 
    else cClrBits = 32; 

    // Allocate memory for the BITMAPINFO structure. (This structure 
    // contains a BITMAPINFOHEADER structure and an array of RGBQUAD 
    // data structures.) 

     if (cClrBits != 24) 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER) + 
                    sizeof(RGBQUAD) * (1<< cClrBits)); 

     // There is no RGBQUAD array for the 24-bit-per-pixel format. 

     else 
         pbmi = (PBITMAPINFO) LocalAlloc(LPTR, 
                    sizeof(BITMAPINFOHEADER)); 

    // Initialize the fields in the BITMAPINFO structure. 

    pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
    pbmi->bmiHeader.biWidth = bmp.bmWidth; 
    pbmi->bmiHeader.biHeight = bmp.bmHeight; 
    pbmi->bmiHeader.biPlanes = bmp.bmPlanes; 
    pbmi->bmiHeader.biBitCount = bmp.bmBitsPixel; 
    if (cClrBits < 24) 
        pbmi->bmiHeader.biClrUsed = (1<<cClrBits); 

    // If the bitmap is not compressed, set the BI_RGB flag. 
    pbmi->bmiHeader.biCompression = BI_RGB; 

    // Compute the number of bytes in the array of color 
    // indices and store the result in biSizeImage. 
    // For Windows NT, the width must be DWORD aligned unless 
    // the bitmap is RLE compressed. This example shows this. 
    // For Windows 95/98/Me, the width must be WORD aligned unless the 
    // bitmap is RLE compressed.
    pbmi->bmiHeader.biSizeImage = ((pbmi->bmiHeader.biWidth * cClrBits +31) & ~31) /8
                                  * pbmi->bmiHeader.biHeight; 
    // Set biClrImportant to 0, indicating that all of the 
    // device colors are important. 
     pbmi->bmiHeader.biClrImportant = 0; 
     return pbmi; 
 } 



void CreateBMPFile(LPTSTR pszFile, PBITMAPINFO pbi, 
                  HBITMAP hBMP, HDC hDC) 
 { 
     HANDLE hf;                 // file handle 
    BITMAPFILEHEADER hdr;       // bitmap file-header 
    PBITMAPINFOHEADER pbih;     // bitmap info-header 
    LPBYTE lpBits;              // memory pointer 
    DWORD dwTotal;              // total count of bytes 
    DWORD cb;                   // incremental count of bytes 
    BYTE *hp;                   // byte pointer 
    DWORD dwTmp; 

    pbih = (PBITMAPINFOHEADER) pbi; 
    lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);

    if (!lpBits) 
		MessageBox(NULL,"CreateBMPFile :: GlobalAlloc Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Retrieve the color table (RGBQUAD array) and the bits 
    // (array of palette indices) from the DIB. 
    if (!GetDIBits(hDC, hBMP, 0, (WORD) pbih->biHeight, lpBits, pbi, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"CreateBMPFile :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }

    // Create the .BMP file. 
    hf = CreateFile(pszFile, 
                   GENERIC_READ | GENERIC_WRITE, 
                   (DWORD) 0, 
                    NULL, 
                   CREATE_ALWAYS, 
                   FILE_ATTRIBUTE_NORMAL, 
                   (HANDLE) NULL); 
    if (hf == INVALID_HANDLE_VALUE) 
        MessageBox(NULL,"CreateBMPFile :: CreateFile Error", "ERROR", MB_ICONERROR | MB_OK);  
    hdr.bfType = 0x4d42;        // 0x42 = "B" 0x4d = "M" 
    // Compute the size of the entire file. 
    hdr.bfSize = (DWORD) (sizeof(BITMAPFILEHEADER) + 
                 pbih->biSize + pbih->biClrUsed 
                 * sizeof(RGBQUAD) + pbih->biSizeImage); 
    hdr.bfReserved1 = 0; 
    hdr.bfReserved2 = 0; 

    // Compute the offset to the array of color indices. 
    hdr.bfOffBits = (DWORD) sizeof(BITMAPFILEHEADER) + 
                    pbih->biSize + pbih->biClrUsed 
                    * sizeof (RGBQUAD); 

    // Copy the BITMAPFILEHEADER into the .BMP file. 
    if (!WriteFile(hf, (LPVOID) &hdr, sizeof(BITMAPFILEHEADER), 
        (LPDWORD) &dwTmp,  NULL)) 
    {
       MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing header", "ERROR", MB_ICONERROR | MB_OK); 
    }

    // Copy the BITMAPINFOHEADER and RGBQUAD array into the file. 
    if (!WriteFile(hf, (LPVOID) pbih, sizeof(BITMAPINFOHEADER) 
                  + pbih->biClrUsed * sizeof (RGBQUAD), 
                  (LPDWORD) &dwTmp, ( NULL)))
        MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing info header", "ERROR", MB_ICONERROR | MB_OK);  

    // Copy the array of color indices into the .BMP file. 
    dwTotal = cb = pbih->biSizeImage; 
    hp = lpBits; 
    if (!WriteFile(hf, (LPSTR) hp, (int) cb, (LPDWORD) &dwTmp,NULL)) 
           MessageBox(NULL,"CreateBMPFile :: WriteFile Error - Writing body", "ERROR", MB_ICONERROR | MB_OK);  

    // Close the .BMP file. 
     if (!CloseHandle(hf)) 
           MessageBox(NULL,"CreateBMPFile :: CloseFile Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Free memory. 
    GlobalFree((HGLOBAL)lpBits);
}


LPBYTE ExtractBits(PBITMAPINFO pbi, 
                  HBITMAP hBMP, HDC hDC) 
 {     
    PBITMAPINFOHEADER pbih;     // bitmap info-header 
    LPBYTE lpBits;              // memory pointer 
    DWORD dwTotal;              // total count of bytes 
    DWORD cb;                   // incremental count of bytes 
    BYTE *hp;                   // byte pointer 

	LPBYTE mybmp = NULL;

    pbih = (PBITMAPINFOHEADER) pbi; 
    lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	if(mybmp){
		free(mybmp);
		mybmp = NULL;
	}
	//mybmp = (LPBYTE)malloc(AlignToPow2(pbih->biHeight) * AlignToPow2(pbih->biWidth) * 3 * sizeof(BYTE));// GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	mybmp = (LPBYTE)malloc((pbih->biHeight) * (pbih->biWidth) * 3 * sizeof(BYTE));// GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);

    if (!lpBits) 
		MessageBox(NULL,"ExtractBits :: GlobalAlloc Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Retrieve the color table (RGBQUAD array) and the bits 
    // (array of palette indices) from the DIB. 
    if (!GetDIBits(hDC, hBMP, 0, (WORD) pbih->biHeight, lpBits, pbi, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"ExtractBits :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }
    
    // Copy the array of color indices into the .BMP file. 
    dwTotal = cb = pbih->biSizeImage; 
    hp = lpBits; 
    RGBQUAD *src = (RGBQUAD*)lpBits;
	RGBOGL  *dst = (RGBOGL*)mybmp;

	// Create the .BMP file. 
	for(int i = 0; i < (pbih->biWidth * pbih->biHeight); i++){
		RGBQUAD s = src[i];
		RGBOGL d;

		d.rgbBlue		= s.rgbBlue;
		d.rgbGreen		= s.rgbGreen;
		d.rgbRed		= s.rgbRed;
		//d.rgbReserved	= s.rgbReserved;

		dst[i] = d;
	}

    // Free memory. 
    GlobalFree((HGLOBAL)lpBits);
	
	return mybmp;
}

void CreateBackgroundTexture(GLenum target, GLuint *texture, int px, int py, int w, int h){
			
	LPBYTE BMPBits = NULL; 

	HDC hdcScreen = GetDC(GetDesktopWindow());//CreateDC("DISPLAY", NULL, NULL, NULL);
	   
	HDC hdcCompatible = CreateCompatibleDC(hdcScreen);

	//HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES));
	HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, w, h);
		
	HBITMAP old = (HBITMAP)SelectObject(hdcCompatible, hbmWnd);

	//BitBlt(hdcCompatible,0,0,GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES), hdcScreen, 0, 0, SRCCOPY | CAPTUREBLT);
	BitBlt(hdcCompatible,0,0,w,h, hdcScreen, px, py, SRCCOPY | CAPTUREBLT);

	// Extract the bitmap bits to array
	PBITMAPINFO pbi = CreateBitmapInfoStruct(hbmWnd);

	BMPBits = ExtractBits(pbi, hbmWnd, hdcCompatible);

	glEnable(target);
	glGenTextures(1, texture);
		
	glBindTexture(target, *texture);

	//tell OpenGL to ignore padding at ends of rows
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexParameterf(target, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(target, GL_TEXTURE_MIN_FILTER, GL_LINEAR);


	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

	glTexImage2D(target, 0, GL_RGB, w, h, 0, GL_RGB, GL_UNSIGNED_BYTE, BMPBits);
	
	glDisable(target);

	free(BMPBits);

	DeleteObject(hbmWnd);
	DeleteDC(hdcCompatible);
	
	ReleaseDC(GetDesktopWindow(),hdcScreen);
	
	   
	return;
}

void UpdateBackgroundTexture(GLenum target, GLuint *texture, int px, int py, int w, int h){
			
	LPBYTE BMPBits = NULL; 

	HDC hdcScreen = GetDC(GetDesktopWindow());//CreateDC("DISPLAY", NULL, NULL, NULL);
	   
	HDC hdcCompatible = CreateCompatibleDC(hdcScreen);

	//HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES));
	HBITMAP hbmWnd = CreateCompatibleBitmap(hdcScreen, w, h);
		
	HBITMAP old = (HBITMAP)SelectObject(hdcCompatible, hbmWnd);

	//BitBlt(hdcCompatible,0,0,GetDeviceCaps(hdcScreen, HORZRES),GetDeviceCaps(hdcScreen, VERTRES), hdcScreen, 0, 0, SRCCOPY | CAPTUREBLT);
	BitBlt(hdcCompatible,0,0,w,h, hdcScreen, px, py, SRCCOPY | CAPTUREBLT);

	// Extract the bitmap bits to array
	PBITMAPINFO pbi = CreateBitmapInfoStruct(hbmWnd);

	BMPBits = ExtractBits(pbi, hbmWnd, hdcCompatible);
	
	glEnable(target);		
	glBindTexture(target, *texture);

	glTexSubImage2D(target, 0, 0, 0, w, h, GL_RGB, GL_UNSIGNED_BYTE, BMPBits);
	
	glDisable(target);

	free(BMPBits);

	DeleteObject(hbmWnd);
	DeleteDC(hdcCompatible);
	
	ReleaseDC(GetDesktopWindow(),hdcScreen);
	
	   
	return;
}

void CreateWindowTexture(GLenum target, GLuint *texture, HWND hWnd, int width, int height){
			
	LPBYTE BMPBits = NULL; 

	HDC hdcWnd = GetDC(GetDesktopWindow());//CreateDC("DISPLAY", NULL, NULL, NULL);
	   
	HDC hdcCompatible = CreateCompatibleDC(hdcWnd);


	//HBITMAP hbmWnd = CreateCompatibleBitmap(hdcWnd, GetDeviceCaps(hdcWnd, HORZRES),GetDeviceCaps(hdcWnd, VERTRES));
	HBITMAP hbmWnd = CreateCompatibleBitmap(hdcWnd, width, height);
			
	HBITMAP old = (HBITMAP)SelectObject(hdcCompatible, hbmWnd);

	PrintWindow(hWnd, hdcCompatible, 0);
	//BitBlt(hdcCompatible,0,0,width,height, hdcWnd, 0, 0, SRCCOPY | CAPTUREBLT);
	
	// Extract the bitmap bits to array
	PBITMAPINFO pbi = CreateBitmapInfoStruct(hbmWnd);

	BMPBits = ExtractBits(pbi, hbmWnd, hdcCompatible);

	SelectObject(hdcCompatible, old);

	// Create OGL Texture of the Window
	glEnable(target);
	glGenTextures(1, texture);
		
	glBindTexture(target, *texture);

	//tell OpenGL to ignore padding at ends of rows
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexParameterf(target, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(target, GL_TEXTURE_MIN_FILTER, GL_LINEAR);


	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);


	glTexImage2D(target, 0, GL_RGB, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, BMPBits);
	
	glDisable(target);

	free(BMPBits);

	ReleaseDC(GetDesktopWindow(),hdcWnd);

	DeleteObject(hbmWnd);
	DeleteDC(hdcCompatible);


	
	   
	return;
}

#include <colordlg.h>

LPBYTE ExtractIconBits(PBITMAPINFO pbColor, HBITMAP hBMPcl,
					   PBITMAPINFO pbMask, HBITMAP hBMPmk,
					   HDC hDC) 
 {     
    PBITMAPINFOHEADER pbih;     // bitmap info-header 
	PBITMAPINFOHEADER pbihm;     // bitmap info-header
    LPBYTE lpBits;              // memory pointer 
	LPBYTE lpMBits;              // memory pointer 
    DWORD dwTotal;              // total count of bytes 
    DWORD cb;                   // incremental count of bytes 
    BYTE *hp;                   // byte pointer 

	LPBYTE mybmp = NULL;

    pbih = (PBITMAPINFOHEADER) pbColor; 
	pbihm = (PBITMAPINFOHEADER) pbMask; 
    lpBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	lpMBits = (LPBYTE) GlobalAlloc(GMEM_FIXED, pbihm->biSizeImage);
	if(mybmp){
		free(mybmp);
		mybmp = NULL;
	}
	//mybmp = (LPBYTE)malloc(AlignToPow2(pbih->biHeight) * AlignToPow2(pbih->biWidth) * 3 * sizeof(BYTE));// GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);
	mybmp = (LPBYTE)malloc((pbih->biHeight) * (pbih->biWidth) * 4 * sizeof(BYTE));// GlobalAlloc(GMEM_FIXED, pbih->biSizeImage);

    if (!lpBits) 
		MessageBox(NULL,"ExtractBits :: GlobalAlloc Error", "ERROR", MB_ICONERROR | MB_OK); 

    // Retrieve the color table (RGBQUAD array) and the bits 
    // (array of palette indices) from the DIB. 
    if (!GetDIBits(hDC, hBMPcl, 0, (WORD) pbih->biHeight, lpBits, pbColor, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"ExtractBits :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }

	if (!GetDIBits(hDC, hBMPmk, 0, (WORD) pbihm->biHeight, lpMBits, pbMask, 
        DIB_RGB_COLORS)) 
    {
        MessageBox(NULL,"ExtractBits :: GetDIBits Error", "ERROR", MB_ICONERROR | MB_OK); 
    }
    
    // Copy the array of color indices into the .BMP file. 
    dwTotal = cb = pbih->biSizeImage; 
    hp = lpBits; 
    RGBQUAD *src = (RGBQUAD*)lpBits;
	bool *srcMk = (bool*)lpMBits;
	RGBAOGL *dst = (RGBAOGL*)mybmp;

	// Create the .BMP file. 
	for(int i = 0; i < (pbih->biWidth * pbih->biHeight); i++){
		RGBQUAD s = src[i];
		bool a = srcMk[i];
		RGBAOGL d;
		
		d.rgbBlue		= s.rgbBlue;
		d.rgbGreen		= s.rgbGreen;
		d.rgbRed		= s.rgbRed;
		d.rgbAlpha		= 255;//(s.rgbBlue == s.rgbGreen == s.rgbRed == 0)?255:0;


		dst[i] = d;
	}

    // Free memory. 
    GlobalFree((HGLOBAL)lpBits);
	GlobalFree((HGLOBAL)lpMBits);
	
	return mybmp;
}


void CreateIconTexture(GLenum target, GLuint *texture, HICON icon){
			
	LPBYTE BMPBits = NULL; 

	HDC hdcWnd = GetDC(GetDesktopWindow());//CreateDC("DISPLAY", NULL, NULL, NULL);
	   
	HDC hdcCompatible = CreateCompatibleDC(hdcWnd);


	int iconW = GetSystemMetrics(SM_CXICON);
	int iconH = GetSystemMetrics(SM_CYICON);
	//HBITMAP hbmWnd = CreateCompatibleBitmap(hdcWnd, GetDeviceCaps(hdcWnd, HORZRES),GetDeviceCaps(hdcWnd, VERTRES));
	HBITMAP hbmWnd = CreateCompatibleBitmap(hdcWnd, iconW, iconH);
			
	HBITMAP old = (HBITMAP)SelectObject(hdcCompatible, hbmWnd);

	RECT r;
	r.top = r.left = 0;
	r.right = iconW;
	r.bottom = iconH;

	//FillRect(hdcCompatible, &r, GetSysColorBrush(COLOR_BLUE));

	ICONINFO ici;

	GetIconInfo(icon, &ici);

	PBITMAPINFO pbia = CreateBitmapInfoStruct(ici.hbmColor);
	//CreateBMPFile("teste.bmp", pbia, ici.hbmColor, hdcCompatible);

	PBITMAPINFO pbib = CreateBitmapInfoStruct(ici.hbmMask);
	//CreateBMPFile("mask.bmp", pbib, ici.hbmMask, hdcCompatible);

	/*FILE *fp = fopen("icon.txt", "w+");*/
	    
	//DrawIconEx(hdcCompatible, 0, 0, icon, iconW, iconH, 0, GetSysColorBrush(COLOR_BLUE), DI_NORMAL);
	DrawIcon(hdcCompatible, 0, 0, icon);

	/*for(int j=0; j<iconH; j++){
	for(int i=0; i<iconW; i++){
		fprintf(fp, "%x", ici.hbmMask[i]
	}
	}*/

	//PrintWindow(hWnd, hdcCompatible, 0);
	
	// Extract the bitmap bits to array
	PBITMAPINFO pbi = CreateBitmapInfoStruct(hbmWnd);

	//BMPBits = ExtractIconBits(pbia, ici.hbmColor, pbib, ici.hbmMask, hdcCompatible);
	BMPBits = ExtractBits(pbi, hbmWnd, hdcCompatible);

	// Create OGL Texture of the Window
	glEnable(target);
	glGenTextures(1, texture);
		
	glBindTexture(target, *texture);

	//tell OpenGL to ignore padding at ends of rows
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexParameterf(target, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(target, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterf(target, GL_TEXTURE_MIN_FILTER, GL_LINEAR);


	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);


	glTexImage2D(target, 0, GL_RGB, iconW, iconH, 0, GL_RGB, GL_UNSIGNED_BYTE, BMPBits);
	//glTexImage2D(target, 0, GL_RGBA, iconW, iconH, 0, GL_RGBA, GL_UNSIGNED_BYTE, BMPBits);

	
	glDisable(target);

	free(BMPBits);

	ReleaseDC(GetDesktopWindow(),hdcWnd);

	DeleteObject(hbmWnd);
	DeleteDC(hdcCompatible);
	
	
	   
	return;
}



// Set the given window as foreground window
// From TaskSwitchXP
// by: Alexander Avdonin
// adapted by: Domingos Freitas
BOOL SwitchToWindow(HWND hwnd){
	BOOL res = FALSE;
	
	if (!IsWindow(hwnd))
		return(FALSE);
	
	
	if (!IsIconic(hwnd)) {

		HWND hwndFrgnd = GetForegroundWindow();
		if (hwnd != hwndFrgnd) {

			BringWindowToTop(hwnd);
			SetWindowPos(hwnd, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

			if (!SetForegroundWindow(hwnd)) {

				if (!hwndFrgnd)
					//hwndFrgnd = FindWindow(L"Shell_TrayWnd", NULL); //LPSTR
					hwndFrgnd = FindWindow("Shell_TrayWnd", NULL); //LPSTR

				DWORD idFrgnd = GetWindowThreadProcessId(hwndFrgnd, NULL);
				DWORD idSwitch = GetWindowThreadProcessId(hwnd, NULL);

				AttachThreadInput(idFrgnd, idSwitch, TRUE);

				if (!SetForegroundWindow(hwnd)) {
					INPUT inp[4];
					ZeroMemory(&inp, sizeof(inp));
					inp[0].type = inp[1].type = inp[2].type = inp[3].type = INPUT_KEYBOARD;
					inp[0].ki.wVk = inp[1].ki.wVk = inp[2].ki.wVk = inp[3].ki.wVk = VK_MENU;
					inp[0].ki.dwFlags = inp[2].ki.dwFlags = KEYEVENTF_EXTENDEDKEY;
					inp[1].ki.dwFlags = inp[3].ki.dwFlags = KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP;
					SendInput(4, inp, sizeof(INPUT));

					res = SetForegroundWindow(hwnd);
				}

				AttachThreadInput(idFrgnd, idSwitch, FALSE);
			}
		}
	} else {
		DWORD dwExStyle = GetWindowLongPtr(hwnd, GWL_EXSTYLE);
		if (dwExStyle & WS_EX_LAYERED) { // see "Bugs with layered windows" in TaskSwtichXP docs
			SetWindowLongPtr(hwnd, GWL_EXSTYLE, dwExStyle & ~WS_EX_LAYERED);
			//SetLayeredWindowAttributes(hwnd, 0, 255, LWA_ALPHA);
		}
		ShowWindow(hwnd, SW_RESTORE);		
	}

	return res;	
}


