#pragma once
#ifndef _WINFUNCTIONS_H_
#define _WINFUNCTIONS_H_

// Needed to use the PrintWindow Function
#define _WIN32_WINNT 0x0501

#include <windows.h>
#include <gl/gl.h>

// Constants for the Alt-Tab management
#define IDH_EXIT						1000
#define IDH_NEXTTASK					1001
#define IDH_PREVTASK					1002
#define IDH_SWITCH						1003
#define IDH_ESCAPE						1004

#define WM_TASKSWITCH					(WM_USER + 984)



void CreateBackgroundTexture(GLenum target, GLuint *texture, int px, int py, int w, int h);
void UpdateBackgroundTexture(GLenum target, GLuint *texture, int px, int py, int w, int h);
void CreateWindowTexture(GLenum target, GLuint *texture, HWND hWnd, int width, int height);
void CreateIconTexture(GLenum target, GLuint *texture, HICON icon);
BOOL CheckOSVersion();
BOOL SwitchToWindow(HWND hwnd);
#endif