#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>	

#include "colors.h"

 float amb[4] = {0.5,0.5,0.5,1.0};
 float black[4] = {0.0,0.0,0.0,1};
 float white[4] = {1.0,1.0,1.0,1};
 float dgrey[4] = {0.1,0.1,0.1,1};
 float grey[4] = {0.4,0.4,0.4,1};
 float red[4] = {0.95,0.26,0.22,1};
 float pink[4] = {1.0,0.0,1.0,1};
 float green[4] = {0.4,1.0,0.2,1};
 float blue[4] = {0.0,0.5,0.8,1};
 float yellow[4] = {1.0,1.0,0.16,1};
 float orange[4] = {1.0,0.52,0.23,1};

TMaterial material[] = 
{
	{
		{0.2, 0.2, 0.2, 1.0},
		{0.8, 0.8, 0.8, 1.0},
		{0.0, 0.0, 0.0, 1.0},
		0.0
	},
	{
		{0.329412, 0.223529, 0.027451, 1.0},
		{0.780392, 0.568627, 0.113725, 1.0},
		{0.992157, 0.941176, 0.807843, 1.0},
		27.8974
	},
	{
		{0.2125, 0.1275, 0.054, 1.0},
		{0.714, 0.4284, 0.18144, 1.0},
		{0.393548, 0.271906, 0.166721, 1.0},
		25.6
	},
	{
		{0.25, 0.148, 0.06475, 1.0},
		{0.4, 0.2368, 0.1036, 1.0},
		{0.774597, 0.458561, 0.200621, 1.0},
		76.8
	},
	{
		{0.25, 0.25, 0.25, 1.0},
		{0.4, 0.4, 0.4, 1.0},
		{0.774597, 0.774597, 0.774597, 1.0},
		76.8
	},	
	{
		{0.19125, 0.0735, 0.0225, 1.0},
		{0.7038, 0.27048, 0.0828, 1.0},
		{0.256777, 0.137622, 0.086014, 1.0},
		12.8
	},
	{
		{0.2295, 0.08825, 0.0275, 1.0},
		{0.5508, 0.2118, 0.066, 1.0},
		{0.580594, 0.223257, 0.0695701, 1.0},
		51.2
	},
	{
		{0.24725, 0.1995, 0.0745, 1.0},
		{0.75164, 0.60648, 0.22648, 1.0},
		{0.628281, 0.555802, 0.366065, 1.0},
		51.2
	},
	{
		{0.24725, 0.2245, 0.0645, 1.0},
		{0.34615, 0.3143, 0.0903, 1.0},
		{0.797357, 0.723991, 0.208006, 1.0},
		83.2
	},
	{
		{0.105882, 0.058824, 0.113725, 1.0},
		{0.427451, 0.470588, 0.541176, 1.0},
		{0.333333, 0.333333, 0.521569, 1.0},
		9.84615
	},
	{
		{0.19225, 0.19225, 0.19225, 1.0},
		{0.50754, 0.50754, 0.50754, 1.0},
		{0.508273, 0.508273, 0.508273, 1.0},
		51.2
	},
	{
		{0.23125, 0.23125, 0.23125, 1.0},
		{0.2775, 0.2775, 0.2775, 1.0},
		{0.773911, 0.773911, 0.773911, 1.0},
		89.6
	},
	{
		{0.0215, 0.1745, 0.0215, 0.55},
		{0.07568, 0.61424, 0.07568, 0.55},
		{0.633, 0.727811, 0.633, 0.55},
		76.8
	},
	{
		{0.135, 0.2225, 0.1575, 0.95},
		{0.54, 0.89, 0.63, 0.95},
		{0.316228, 0.316228, 0.316228, 0.95},
		12.8
	},
	{
		{0.05375, 0.05, 0.06625, 0.82},
		{0.18275, 0.17, 0.22525, 0.82},
		{0.332741, 0.328634, 0.346435, 0.82},
		38.4
	},
	{
		{0.25, 0.20725, 0.20725, 0.922},
		{1.0, 0.829, 0.829, 0.922},
		{0.296648, 0.296648, 0.296648, 0.922},
		11.264
	},
	{
		{0.1745, 0.01175, 0.01175, 0.55},
		{0.61424, 0.04136, 0.04136, 0.55},
		{0.727811, 0.626959, 0.626959, 0.55},
		76.8
	},
	{
		{0.1, 0.18725, 0.1745, 0.8},
		{0.396, 0.74151, 0.69102, 0.8},
		{0.297254, 0.30829, 0.306678, 0.8},
		12.8
	},
	{
		{0.0, 0.0, 0.0, 1.0},
		{0.01, 0.01, 0.01, 1.0},
		{0.50, 0.50, 0.50, 1.0},
		32
	},
	{
		{0.02, 0.02, 0.02, 1.0},
		{0.01, 0.01, 0.01, 1.0},
		{0.4, 0.4, 0.4, 1.0},
		10
	}
}; 

void setMaterial(int mat){
	/*char tt[1024];
	sprintf(tt, "%f,%f,%f,%f", material[mat].amb[0], material[mat].amb[1], material[mat].amb[2], material[mat].amb[3]);
	MessageBox(NULL, tt, "alpha", MB_OK);
	*/
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, material[mat].amb);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, material[mat].dif);		// Setup The Ambient Light
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, material[mat].spe);		// Setup The Diffuse Light
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, material[mat].shi);
    return;	
}

void setMaterial(float color[4], float diff[4], float alpha){
	setMaterial(None);
	color[3] = alpha;
	diff[3] = alpha;
	//glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, color);
	//glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diff);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, color);
    return;	
}