using System;
using System.Text;
using System.Runtime.InteropServices;

namespace OGLTaskSwitchConfig
{
	/// <summary>
	/// Summary description for ConfigHandler.
	/// </summary>
	public class ConfigHandler
	{
		[DllImport("kernel32.dll")]
		public static extern int WritePrivateProfileString(StringBuilder AppName, StringBuilder key, StringBuilder val, StringBuilder file);
		[DllImport("kernel32.dll")]
		public static extern int GetPrivateProfileInt(StringBuilder AppName, StringBuilder key, int defaultVal, StringBuilder file);
		[DllImport("kernel32.dll")]
		public static extern StringBuilder GetPrivateProfileString(StringBuilder AppName, StringBuilder key, StringBuilder defaultVal, StringBuilder file);

		public StringBuilder appName = new StringBuilder();
		public StringBuilder appFile = new StringBuilder();

		public ConfigHandler(string appName, string appFile)
		{
			this.appName = new StringBuilder(appName);
			this.appFile = new StringBuilder(appFile);
		}

		public int WriteStrToIniFile(string key, string keyVal)
		{
			int res = WritePrivateProfileString(this.appName, 
				new StringBuilder(key), 
				new StringBuilder(keyVal), 
				this.appFile);
			return res;
		}

		public int WriteIntToIniFile(string key, int keyVal)
		{
			int res = WritePrivateProfileString(this.appName, 
				new StringBuilder(key), 
				new StringBuilder("" + keyVal), 
				this.appFile);
			return res;
		}

		public StringBuilder ReadStrFromIniFile(string key, string defValue)
		{
			StringBuilder res = GetPrivateProfileString(this.appName,
				new StringBuilder(key),
				new StringBuilder(defValue),
				this.appFile);
			return res;
		}

		public int ReadIntFromIniFile(string key, int defValue)
		{
			int res = GetPrivateProfileInt(this.appName,
				new StringBuilder(key),
				defValue,
				this.appFile);
			return res;
		}
	}
}
