using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace OGLTaskSwitchConfig
{	
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class OGLTaskSwitchConfig : System.Windows.Forms.Form
	{			
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label lblDepthBits;
		private System.Windows.Forms.Label lblColorDepth;
		private System.Windows.Forms.ListBox lstScrRes;
		private System.Windows.Forms.Label lblScrRes;
		private System.Windows.Forms.Button cmdSave;
		private System.Windows.Forms.Button cmdExit;
		private System.Windows.Forms.ListBox lstColorDepth;
		private System.Windows.Forms.ListBox lstDepthBits;
		private System.Windows.Forms.CheckBox ckbPrettyText;
		private System.Windows.Forms.CheckBox ckbUpdBackTexture;
		private System.Windows.Forms.GroupBox grpFSAA;
		private System.Windows.Forms.Label lblFSAASubtitle;
		private System.Windows.Forms.TrackBar trkFSAA;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private ConfigHandler conf;


		public OGLTaskSwitchConfig()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			conf = new ConfigHandler("OGLTaskSwitch", ".\\OGLTaskSwitch.ini");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(OGLTaskSwitchConfig));
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.grpFSAA = new System.Windows.Forms.GroupBox();
			this.lblFSAASubtitle = new System.Windows.Forms.Label();
			this.trkFSAA = new System.Windows.Forms.TrackBar();
			this.ckbUpdBackTexture = new System.Windows.Forms.CheckBox();
			this.ckbPrettyText = new System.Windows.Forms.CheckBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.lstDepthBits = new System.Windows.Forms.ListBox();
			this.lstColorDepth = new System.Windows.Forms.ListBox();
			this.lblDepthBits = new System.Windows.Forms.Label();
			this.lblColorDepth = new System.Windows.Forms.Label();
			this.lstScrRes = new System.Windows.Forms.ListBox();
			this.lblScrRes = new System.Windows.Forms.Label();
			this.cmdSave = new System.Windows.Forms.Button();
			this.cmdExit = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.grpFSAA.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.trkFSAA)).BeginInit();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.grpFSAA);
			this.groupBox1.Controls.Add(this.ckbUpdBackTexture);
			this.groupBox1.Controls.Add(this.ckbPrettyText);
			this.groupBox1.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.groupBox1.Location = new System.Drawing.Point(8, 168);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(408, 176);
			this.groupBox1.TabIndex = 6;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = " Appearance";
			// 
			// grpFSAA
			// 
			this.grpFSAA.Controls.Add(this.lblFSAASubtitle);
			this.grpFSAA.Controls.Add(this.trkFSAA);
			this.grpFSAA.Location = new System.Drawing.Point(8, 74);
			this.grpFSAA.Name = "grpFSAA";
			this.grpFSAA.Size = new System.Drawing.Size(168, 88);
			this.grpFSAA.TabIndex = 11;
			this.grpFSAA.TabStop = false;
			this.grpFSAA.Text = "Antialiasing Settings";
			// 
			// lblFSAASubtitle
			// 
			this.lblFSAASubtitle.Location = new System.Drawing.Point(9, 55);
			this.lblFSAASubtitle.Name = "lblFSAASubtitle";
			this.lblFSAASubtitle.Size = new System.Drawing.Size(144, 23);
			this.lblFSAASubtitle.TabIndex = 12;
			this.lblFSAASubtitle.Text = "None  2x   4x    6x";
			// 
			// trkFSAA
			// 
			this.trkFSAA.LargeChange = 1;
			this.trkFSAA.Location = new System.Drawing.Point(8, 24);
			this.trkFSAA.Maximum = 3;
			this.trkFSAA.Name = "trkFSAA";
			this.trkFSAA.Size = new System.Drawing.Size(136, 45);
			this.trkFSAA.TabIndex = 11;
			this.trkFSAA.Tag = "";
			// 
			// ckbUpdBackTexture
			// 
			this.ckbUpdBackTexture.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.ckbUpdBackTexture.Location = new System.Drawing.Point(8, 48);
			this.ckbUpdBackTexture.Name = "ckbUpdBackTexture";
			this.ckbUpdBackTexture.Size = new System.Drawing.Size(288, 24);
			this.ckbUpdBackTexture.TabIndex = 1;
			this.ckbUpdBackTexture.Text = "Update Background Texture (w/ glitches)";
			// 
			// ckbPrettyText
			// 
			this.ckbPrettyText.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.ckbPrettyText.Location = new System.Drawing.Point(8, 24);
			this.ckbPrettyText.Name = "ckbPrettyText";
			this.ckbPrettyText.Size = new System.Drawing.Size(160, 24);
			this.ckbPrettyText.TabIndex = 0;
			this.ckbPrettyText.Text = "Draw Shadowed Text";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.lstDepthBits);
			this.groupBox2.Controls.Add(this.lstColorDepth);
			this.groupBox2.Controls.Add(this.lblDepthBits);
			this.groupBox2.Controls.Add(this.lblColorDepth);
			this.groupBox2.Controls.Add(this.lstScrRes);
			this.groupBox2.Controls.Add(this.lblScrRes);
			this.groupBox2.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.groupBox2.Location = new System.Drawing.Point(8, 8);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(408, 152);
			this.groupBox2.TabIndex = 7;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = " Device";
			// 
			// lstDepthBits
			// 
			this.lstDepthBits.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstDepthBits.ItemHeight = 14;
			this.lstDepthBits.Items.AddRange(new object[] {
															  "16 bits",
															  "24 bits"});
			this.lstDepthBits.Location = new System.Drawing.Point(280, 48);
			this.lstDepthBits.Name = "lstDepthBits";
			this.lstDepthBits.Size = new System.Drawing.Size(120, 86);
			this.lstDepthBits.TabIndex = 13;
			// 
			// lstColorDepth
			// 
			this.lstColorDepth.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstColorDepth.ItemHeight = 14;
			this.lstColorDepth.Items.AddRange(new object[] {
															   "16 bpp",
															   "32 bpp"});
			this.lstColorDepth.Location = new System.Drawing.Point(144, 48);
			this.lstColorDepth.Name = "lstColorDepth";
			this.lstColorDepth.Size = new System.Drawing.Size(120, 86);
			this.lstColorDepth.TabIndex = 12;
			// 
			// lblDepthBits
			// 
			this.lblDepthBits.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblDepthBits.Location = new System.Drawing.Point(280, 24);
			this.lblDepthBits.Name = "lblDepthBits";
			this.lblDepthBits.Size = new System.Drawing.Size(112, 24);
			this.lblDepthBits.TabIndex = 10;
			this.lblDepthBits.Text = "Depth Quality";
			// 
			// lblColorDepth
			// 
			this.lblColorDepth.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblColorDepth.Location = new System.Drawing.Point(144, 24);
			this.lblColorDepth.Name = "lblColorDepth";
			this.lblColorDepth.Size = new System.Drawing.Size(112, 24);
			this.lblColorDepth.TabIndex = 8;
			this.lblColorDepth.Text = "Color Quality";
			// 
			// lstScrRes
			// 
			this.lstScrRes.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstScrRes.ItemHeight = 14;			
			this.lstScrRes.Items.AddRange(new object[] {
														   "320 x 200",
														   "640 x 400",
														   "640 x 480",
														   "720 x 480",
														   "800 x 600",
														   "1024 x 768",
														   "1154 x 864",
														   "1280 x 720",
														   "1280 x 1024"});
			this.lstScrRes.Location = new System.Drawing.Point(8, 48);
			this.lstScrRes.Name = "lstScrRes";
			this.lstScrRes.Size = new System.Drawing.Size(120, 86);
			this.lstScrRes.TabIndex = 7;
			// 
			// lblScrRes
			// 
			this.lblScrRes.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblScrRes.Location = new System.Drawing.Point(8, 24);
			this.lblScrRes.Name = "lblScrRes";
			this.lblScrRes.Size = new System.Drawing.Size(136, 24);
			this.lblScrRes.TabIndex = 6;
			this.lblScrRes.Text = "Window Resolution";
			// 
			// cmdSave
			// 
			this.cmdSave.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdSave.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmdSave.Location = new System.Drawing.Point(256, 368);
			this.cmdSave.Name = "cmdSave";
			this.cmdSave.TabIndex = 8;
			this.cmdSave.Text = "Save";
			this.cmdSave.Click += new System.EventHandler(this.cmdSave_Click);
			// 
			// cmdExit
			// 
			this.cmdExit.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdExit.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmdExit.Location = new System.Drawing.Point(336, 368);
			this.cmdExit.Name = "cmdExit";
			this.cmdExit.TabIndex = 9;
			this.cmdExit.Text = "Exit";
			this.cmdExit.Click += new System.EventHandler(this.cmdExit_Click);
			// 
			// OGLTaskSwitchConfig
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 411);
			this.Controls.Add(this.cmdExit);
			this.Controls.Add(this.cmdSave);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "OGLTaskSwitchConfig";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "OpenGL Task Switch Configuration";
			this.Load += new System.EventHandler(this.OGLTaskSwitchConfig_Load);
			this.groupBox1.ResumeLayout(false);
			this.grpFSAA.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.trkFSAA)).EndInit();
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.EnableVisualStyles();
			OGLTaskSwitchConfig otsc = new OGLTaskSwitchConfig();				
			Application.Run(otsc);
		}

		private void cmdExit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void cmdSave_Click(object sender, System.EventArgs e)
		{
			bool errors = false;
			string errorStr = "";

			if(this.lstScrRes.SelectedIndex < 0)
			{
				errors = true;
				errorStr += "You MUST chose a window resolution.\n";
			}

			if(this.lstColorDepth.SelectedIndex < 0)
			{
				errors = true;
				errorStr += "You MUST chose a Color Quality.\n";
			}

			if(this.lstDepthBits.SelectedIndex < 0)
			{
				errors = true;
				errorStr += "You MUST chose a Depth Quality.\n";
			}

			if(errors)
			{
				MessageBox.Show(errorStr, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			} 
			else 
			{
				string[] winres = this.lstScrRes.SelectedItem.ToString().Split("x".ToCharArray());
				string[] colorbits = this.lstColorDepth.SelectedItem.ToString().Trim().Split(" bpp".ToCharArray());
				string[] depthbits = this.lstDepthBits.SelectedItem.ToString().Trim().Split(" bits".ToCharArray());
				int xres = int.Parse(winres[0]);
				int yres = int.Parse(winres[1]);
				int color = int.Parse(colorbits[0]);
				int depth = int.Parse(depthbits[0]);

				int pText = this.ckbPrettyText.Checked ? 1 : 0;
				int updtBack = this.ckbUpdBackTexture.Checked ? 1 : 0;
				int aa = 0;
				switch(this.trkFSAA.Value)
				{
					case 1:
					{
						aa = 2;
						break;
					}
					case 2:
					{
						aa = 4;
						break;
					}
					case 3:
					{
						aa = 6;
						break;
					}
					default:
					{
						aa = 0;
						break;
					}
				}
				
				int svres = 0;
				svres += this.conf.WriteIntToIniFile("xres", xres);
				svres += this.conf.WriteIntToIniFile("yres", yres);
				svres += this.conf.WriteIntToIniFile("bpp", color);
				svres += this.conf.WriteIntToIniFile("zres", depth);

				svres += this.conf.WriteIntToIniFile("usePrettyText", pText);
				svres += this.conf.WriteIntToIniFile("updtBackTexture", updtBack);
				svres += this.conf.WriteIntToIniFile("nxfsaa", aa);

//				if(svres == 0)
//				{
//					MessageBox.Show("An ERROR occurred when saving the " + this.conf.appName + " configuration into file " + this.conf.appFile, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
//				} 
//				else 
//				{

					MessageBox.Show(this.conf.appName + " Configuration saved successfully into file " + this.conf.appFile, "Configuration Saved", MessageBoxButtons.OK, MessageBoxIcon.Information);
//				}
			}

			return;
		}

		private void OGLTaskSwitchConfig_Load(object sender, System.EventArgs e)
		{
			// window resolution			
			int xres = this.conf.ReadIntFromIniFile("xres", 640);
			int yres = this.conf.ReadIntFromIniFile("yres", 480);
			this.lstScrRes.SelectedIndex = this.lstScrRes.Items.IndexOf(xres + " x " + yres);

			// Color quality
			int bpp = this.conf.ReadIntFromIniFile("bpp", 16);
			this.lstColorDepth.SelectedIndex = this.lstColorDepth.Items.IndexOf(bpp + " bpp");

			// Depth Quality
			int zres = this.conf.ReadIntFromIniFile("zres", 16);
			this.lstDepthBits.SelectedIndex = this.lstDepthBits.Items.IndexOf(zres + " bits");


			this.ckbPrettyText.Checked = this.conf.ReadIntFromIniFile("usePrettyText", 1) == 1;
			this.ckbUpdBackTexture.Checked = this.conf.ReadIntFromIniFile("updtBackTexture", 0) == 1;
			this.trkFSAA.Value = this.conf.ReadIntFromIniFile("nxfsaa", 0)/2;
		}
	}
}
